//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef COEX_BT_DRIVER_SV
`define COEX_BT_DRIVER_SV


class coex_bt_driver extends uvm_driver #(coex_bt_seq_item);

  `uvm_component_utils(coex_bt_driver)

  virtual coex_bt_if vif;
  coex_bt_config     cfg;


  function new (string name = "coex_bt_driver", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual coex_bt_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    fork
      get_and_drive();
      /* add other tasks here */
    join_none;
  endtask : run_phase

  task initialize();
    vif.bt_tx      <= 0;
    vif.bt_rx      <= 0;
    vif.bt_event   <= 0;
    vif.bt_pti     <= 0;
    vif.bt_channel <= 0;
    vif.bt_bw      <= 0;
  endtask : initialize


  task get_and_drive();
    initialize();

    forever begin
      `uvm_info(get_type_name(), "Start of a bus cycle detected.", UVM_DEBUG)
      seq_item_port.get_next_item(req);
      `uvm_info(get_type_name(), "Got new item.", UVM_DEBUG)

      // drive interface signals
      case (req.cmd)
        BT_SET_TX: begin
          vif.bt_tx <= req.sig_value[`BT_TX];
        end
        BT_SET_RX: begin
          vif.bt_rx <= req.sig_value[`BT_RX];
        end
        BT_SET_EVENT: begin
          vif.bt_event <= req.sig_value[`BT_EVENT];
        end
        BT_SET_PTI: begin
          vif.bt_pti <= req.sig_value[`BT_PTI];
        end
        BT_SET_CHANNEL: begin
          vif.bt_channel <= req.sig_value[`BT_CHANNEL];
        end
        BT_SET_BW: begin
          vif.bt_bw <= req.sig_value[`BT_BW];
        end
        BT_RESET: begin
          initialize();
        end
      endcase

      seq_item_port.item_done();
    end // forever
  endtask : get_and_drive

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase

endclass : coex_bt_driver

`endif
