//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef COEX_BT_MONITOR_SV
`define COEX_BT_MONITOR_SV


class coex_bt_monitor extends uvm_monitor;

  virtual coex_bt_if vif;
  coex_bt_config     cfg;
  uvm_analysis_port #(coex_bt_seq_item) ap;

  `uvm_component_utils(coex_bt_monitor)

  function new(string name = "coex_bt_monitor", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual coex_bt_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

    ap = new("ap", this);
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    fork
      collect_transaction();
      /* add some task calls here */
    join_none;
  endtask : run_phase


  task collect_transaction();
    coex_bt_seq_item item = coex_bt_seq_item::type_id::create("item");

    forever begin

      fork : COLLECT_TRANS
        begin
          @(posedge vif.bt_tx);
          item.cmd = BT_SET_TX;
        end
        begin
          @(posedge vif.bt_rx);
          item.cmd = BT_SET_RX;
        end
        begin
          @(posedge vif.bt_event);
          item.cmd = BT_SET_EVENT;
        end
        begin
          @(vif.bt_tx_abort);
          if (vif.bt_tx_abort == 1) begin
            item.bt_tx_abort = 1'b1;
          end
          else begin
            item.bt_tx_abort = 1'b0;
          end
          item.cmd = BT_TX_ABORT;
        end
        begin
          @(vif.bt_rx_abort);
          if (vif.bt_rx_abort == 1) begin
            item.bt_rx_abort = 1'b1;
          end
          else begin
            item.bt_rx_abort = 1'b0;
          end
          item.cmd = BT_RX_ABORT;
        end
        begin
          @(vif.bt_bw);
          item.cmd = BT_SET_BW;
        end
        begin
          wait (item.sig_value[`BT_PTI] != vif.bt_pti);
        end
        begin
          wait (item.sig_value[`BT_CHANNEL] != vif.bt_channel);
        end
      join_any

      // set interface signals in item
      item.sig_value[`BT_TX     ] = vif.bt_tx      ;
      item.sig_value[`BT_RX     ] = vif.bt_rx      ;
      item.sig_value[`BT_EVENT  ] = vif.bt_event   ;
      item.bt_tx_abort            = vif.bt_tx_abort;
      item.bt_rx_abort            = vif.bt_rx_abort;
      item.sig_value[`BT_PTI    ] = vif.bt_pti     ;
      item.sig_value[`BT_CHANNEL] = vif.bt_channel ;
      item.sig_value[`BT_BW     ] = vif.bt_bw      ;

      if (cfg.has_checks)
        perform_checks();

      `uvm_info(get_type_name(), $sformatf("Transaction collected :\n%s", item.sprint()), UVM_HIGH)

      ap.write(item);
    end// forever
  endtask : collect_transaction


  function void perform_checks();
  endfunction : perform_checks

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase


endclass : coex_bt_monitor

`endif //COEX_BT_MONITOR_SV
