//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef IRQ_RAW_AGENT_SV
`define IRQ_RAW_AGENT_SV

//-----------------------------------

class irq_raw_agent #(int WIDTH = 8) extends uvm_agent;

  irq_raw_config    cfg;
  irq_raw_monitor #(WIDTH)   monitor;
  irq_raw_coverage #(WIDTH) coverage;

  `uvm_component_param_utils_begin(irq_raw_agent #(WIDTH))
    `uvm_field_object(cfg, UVM_DEFAULT)
  `uvm_component_utils_end

  function new (string name = "irq_raw_agent", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    // Get Configuration
    if (!uvm_config_db#(irq_raw_config)::get(this, "", "cfg", cfg)) begin
       `uvm_fatal(get_type_name(), "Config not set for slave agent using default is_active")
    end

    // Create components
    monitor = irq_raw_monitor #(WIDTH)::type_id::create("monitor",this);
    monitor.cfg = cfg;
    if (cfg.has_coverage) begin
      coverage = irq_raw_coverage #(WIDTH)::type_id::create("coverage", this);
    end

  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    if (cfg.has_coverage) begin
      monitor.ap.connect(coverage.analysis_export);
    end

  endfunction : connect_phase

endclass : irq_raw_agent

`endif
