//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef IRQ_RAW_COMMON_SV
`define IRQ_RAW_COMMON_SV

`define MAC_IRQ_CTRL_IN_WIDTH   55

`define MAC_IRQ_CTRL_OUT_WIDTH  6
`define PLATFORM_IN_IRQ_WIDTH   64
`define PLATFORM_OUT_IRQ_WIDTH  1

// General Interrupt Event Register
`define MAC_IRQ_IMPPRITBTT_BIT_POS            0
`define MAC_IRQ_IMPSECTBTT_BIT_POS            1
`define MAC_IRQ_IDLEINTERRUPT_BIT_POS         2
`define MAC_IRQ_ABSGENTIMERS_BIT_POS          3
// bit 4 is reserved
`define MAC_IRQ_COEXEVENT_BIT_POS             4
`define MAC_IRQ_MACPHYIFOVERFLOW_BIT_POS      5
`define MAC_IRQ_RXDMAEMPTY_BIT_POS            6
`define MAC_IRQ_RXFIFOOVERFLOW_BIT_POS        7
`define MAC_IRQ_OLBCOFDM_BIT_POS              8
`define MAC_IRQ_OLBCDSSS_BIT_POS              9
`define MAC_IRQ_TIMSET_BIT_POS                10
`define MAC_IRQ_PTERROR_BIT_POS               11
`define MAC_IRQ_AC0TXDMADEAD_BIT_POS          12
`define MAC_IRQ_AC1TXDMADEAD_BIT_POS          13
`define MAC_IRQ_AC2TXDMADEAD_BIT_POS          14
`define MAC_IRQ_AC3TXDMADEAD_BIT_POS          15
`define MAC_IRQ_BCNTXDMADEAD_BIT_POS          16
`define MAC_IRQ_IMPPRIDTIM_BIT_POS            17
`define MAC_IRQ_IMPSECDTIM_BIT_POS            18
`define MAC_IRQ_HWERR_BIT_POS                 19
`define MAC_IRQ_MACPHYIFUNDERRUN_BIT_POS      20
`define MAC_IRQ_PHYERR_BIT_POS                21
`define MAC_IRQ_PHYRXSTART_BIT_POS            22
`define MAC_IRQ_RXHEADERDMADEAD_BIT_POS       23
`define MAC_IRQ_RXPAYLOADDMADEAD_BIT_POS      24
`define MAC_IRQ_TBTXDMADEAD_BIT_POS           25

// Transmit/Receive Interrupt Event Register
`define MAC_IRQ_AC0PROTTRIGGER_BIT_POS        26
`define MAC_IRQ_AC1PROTTRIGGER_BIT_POS        27
`define MAC_IRQ_AC2PROTTRIGGER_BIT_POS        28
`define MAC_IRQ_AC3PROTTRIGGER_BIT_POS        29
`define MAC_IRQ_TBPROTTRIGGER_BIT_POS         30
`define MAC_IRQ_RDPROTTRIGGER_BIT_POS         31
`define MAC_IRQ_AC0TXTRIGGER_BIT_POS          32
`define MAC_IRQ_AC1TXTRIGGER_BIT_POS          33
`define MAC_IRQ_AC2TXTRIGGER_BIT_POS          34
`define MAC_IRQ_AC3TXTRIGGER_BIT_POS          35
`define MAC_IRQ_BCNTXTRIGGER_BIT_POS          36
`define MAC_IRQ_TBTXTRIGGER_BIT_POS           37
`define MAC_IRQ_RDTXTRIGGER_BIT_POS           38
`define MAC_IRQ_TXOPCOMPLETE_BIT_POS          39
`define MAC_IRQ_TIMERTXTRIGGER_BIT_POS        40
`define MAC_IRQ_SECUSERTXTRIGGER_BIT_POS      41
`define MAC_IRQ_RXBUFFER1TRIGGER_BIT_POS      42
`define MAC_IRQ_TIMERRXTRIGGER_BIT_POS        43
`define MAC_IRQ_RXBUFFER2TRIGGER_BIT_POS      44
`define MAC_IRQ_COUNTERRXTRIGGER_BIT_POS      45
`define MAC_IRQ_AC0BWDROPTRIGGER_BIT_POS      46
`define MAC_IRQ_AC1BWDROPTRIGGER_BIT_POS      47
`define MAC_IRQ_AC2BWDROPTRIGGER_BIT_POS      48
`define MAC_IRQ_AC3BWDROPTRIGGER_BIT_POS      49
`define MAC_IRQ_AC0TXBUFTRIGGER_BIT_POS       50
`define MAC_IRQ_AC1TXBUFTRIGGER_BIT_POS       51
`define MAC_IRQ_AC2TXBUFTRIGGER_BIT_POS       52
`define MAC_IRQ_AC3TXBUFTRIGGER_BIT_POS       53
`define MAC_IRQ_BCNTXBUFTRIGGER_BIT_POS       54


// Positions in the registers of the interrupts
// General interrupts

`define IMPRITBTT_POS                         0
`define IMSECTBTT_POS                         1
`define IDLEINT_POS                           2
`define ABSGENTIMER_POS                       3
`define COEXEVENT_POS                         5
`define MACPHYOVERFLOW_POS                    6
`define RXDMAEMPTY_POS                        7
`define RXFIFOOVERFLOW_POS                    8
`define OLBCOFDM_POS                          9
`define OLBCDSS_POS                           10
`define TIMSET_POS                            11
`define PTERROR_POS                           12
`define AC0TXDMADEAD_POS                      13
`define AC1TXDMADEAD_POS                      14
`define AC2TXDMADEAD_POS                      15
`define AC3TXDMADEAD_POS                      16
`define BCNTXDMADEAD_POS                      17
`define IMPRIDTIM_POS                         18
`define IMPSECDTIM_POS                        19
`define HWERR_POS                             20
`define MACPHYIFUNDERRUN_POS                  21
`define PHYERR_POS                            22
`define PHYRXSTART_POS                        23
`define RXHEADERDMADEAD_POS                   24
`define RXPAYLOADDMADEAD_POS                  25
`define TBTXDMADEAD_POS                       26

// Tx/Rx event register

`define AC0PROTTRIGGER_POS                    0
`define AC1PROTTRIGGER_POS                    1
`define AC2PROTTRIGGER_POS                    2
`define AC3PROTTRIGGER_POS                    3
`define TBPROTTRIGGER_POS                     4
`define RDPROTTRIGGER_POS                     5
`define AC0TXTRIGGER_POS                      6
`define AC1TXTRIGGER_POS                      7
`define AC2TXTRIGGER_POS                      8
`define AC3TXTRIGGER_POS                      9
`define BCNTXTRIGGER_POS                      10
`define TBTXTRIGGER_POS                       11
`define RDTXTRIGGER_POS                       12
`define TXOPCOMPLETE_POS                      13
`define TIMERTXTRIGGER_POS                    14
`define SECUSERTXTRIGGER_POS                  15
`define RXBUFFER1TRIGGER_POS                  16
`define TIMERRXTRIGGER_POS                    17
`define RXBUFFER2TRIGGER_POS                  18
`define COUNTERRXTRIGGER_POS                  19
`define AC0BWDROPTRIGGER_POS                  20
`define AC1BWDROPTRIGGER_POS                  21
`define AC2BWDROPTRIGGER_POS                  22
`define AC3BWDROPTRIGGER_POS                  23
`define AC0TXBUFTRIGGER_POS                   24
`define AC1TXBUFTRIGGER_POS                   25
`define AC2TXBUFTRIGGER_POS                   26
`define AC3TXBUFTRIGGER_POS                   27
`define BCNTXBUFTRIGGER_POS                   28

// MAC Interrupt controller output connections
`define MAC_IRQ_OUT_INTTXRXTIMER_N_BIT_POS    0
`define MAC_IRQ_OUT_INTTXRXMISC_N_BIT_POS     1
`define MAC_IRQ_OUT_INTRXTRIGGER_N_BIT_POS    2
`define MAC_IRQ_OUT_INTTXTRIGGER_N_BIT_POS    3
`define MAC_IRQ_OUT_INTGEN_N_BIT_POS          4
`define MAC_IRQ_OUT_INTPROTTRIGGER_N_BIT_POS  5

`endif// IRQ_RAW_COMMON_SV
