//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef IRQ_RAW_CONFIG_SV
`define IRQ_RAW_CONFIG_SV

class irq_raw_config extends uvm_object;

  uvm_active_passive_enum        is_active = UVM_PASSIVE;
  bit                            has_coverage = 1;
  bit                            has_checks   = 1;
  bit                            irq_raw_polarity = 0; // 0 - active low, 1 - active high

  `uvm_object_utils_begin(irq_raw_config)
    `uvm_field_enum(uvm_active_passive_enum, is_active, UVM_DEFAULT)
    `uvm_field_int(has_coverage, UVM_DEFAULT)
    `uvm_field_int(has_checks, UVM_DEFAULT)
    `uvm_field_int(irq_raw_polarity, UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "irq_raw_config");
    super.new(name);
  endfunction

endclass : irq_raw_config

`endif
