//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef IRQ_RAW_MONITOR_SV
`define IRQ_RAW_MONITOR_SV


class irq_raw_monitor #(int WIDTH = 8) extends uvm_monitor;

  virtual irq_raw_if #(WIDTH) vif;
  irq_raw_config     cfg;
  uvm_analysis_port #(irq_raw_seq_item #(WIDTH)) ap;

  `uvm_component_param_utils(irq_raw_monitor #(WIDTH))


// Maximum amount of irq signals
bit[WIDTH-1:0] raw_irq_prev_vect;
bit[WIDTH-1:0] raw_irq_current_vect;

  function new(string name = "irq_raw_monitor", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual irq_raw_if #(WIDTH) )::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

    ap = new("ap", this);
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    fork
      collect_transaction();
      observe_reset();
      /* add some task calls here */
    join_none;
  endtask : run_phase


  task observe_reset();
    wait(vif.nrst === 1'b0);  // Reset assertion
    `uvm_info(get_type_name(), "Transaction recording interrupted by reset assertion.", UVM_DEBUG);
    // Clear both vectors
    for(int unsigned i = 0; i < WIDTH; i++) begin
     raw_irq_current_vect[i] = (cfg.irq_raw_polarity) ? 1'b0 : 1'b1; // Set inactive state
     raw_irq_prev_vect[i]    = (cfg.irq_raw_polarity) ? 1'b0 : 1'b1; // Set inactive state
    end
    wait(vif.nrst === 1'b1);  // Reset deassertion
  endtask : observe_reset


  task collect_transaction();
    irq_raw_seq_item #(WIDTH) item = irq_raw_seq_item #(WIDTH)::type_id::create("item");

    forever begin
      if (cfg.irq_raw_polarity)
        @(negedge vif.clk iff vif.nrst === 1'b1);
      else
        @(posedge vif.clk iff vif.nrst === 1'b1);

     raw_irq_current_vect = vif.irq_sig;

      // Check if the new vector differs from the previous one
     if(|(raw_irq_prev_vect ^ raw_irq_current_vect)) begin

     `uvm_info(get_full_name(), "RAW IRQ lines changed...", UVM_DEBUG);

      // Collect the new item
      item.irq_sig         = vif.irq_sig;
      //
      raw_irq_prev_vect = raw_irq_current_vect;

      // Collect the new item !!!
      `uvm_info(get_type_name(), $sformatf("Transaction collected :\n%s", item.sprint()), UVM_DEBUG)
      if (cfg.has_checks) begin
        perform_checks();
      end

      ap.write(item);

     end

    end// forever
  endtask : collect_transaction


  function void perform_checks();
   // Empty for the moment
  endfunction : perform_checks

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase


endclass : irq_raw_monitor

`endif // IRQ_RAW_MONITOR_SV
