//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_SEQ_ITEM_SV
`define MAC_SEQ_ITEM_SV


class mac_seq_item extends uvm_sequence_item;

       PPDU_frame       frame;
  rand transaction_e    trans;
  rand int              rx_frame_num; // number of Rx frames to receive
  rand int              idle_cycles; //number of idle cycles before turning on keep_rf_on

  `uvm_object_utils_begin(mac_seq_item)
    `uvm_field_object(frame, UVM_DEFAULT)
    `uvm_field_enum(transaction_e, trans, UVM_DEFAULT)
    `uvm_field_int(rx_frame_num, UVM_DEFAULT)
    `uvm_field_int(idle_cycles, UVM_DEFAULT)
  `uvm_object_utils_end

  constraint c_rx_frame_num {
    rx_frame_num < 200;
    rx_frame_num > 0;
    idle_cycles  >= 25; idle_cycles <= 50;
  }

  function new (string name = "mac_seq_item");
    super.new(name);

    frame = PPDU_frame::type_id::create("frame");
  endfunction : new

endclass : mac_seq_item

`endif //MAC_SEQ_ITEM_SV
