//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef PHY_RX_FRAME_ERR_SEQ_SV
`define PHY_RX_FRAME_ERR_SEQ_SV

class phy_rx_frame_err_seq extends phy_seq_base;

  PPDU_frame frame;

  `uvm_object_utils(phy_rx_frame_err_seq)


  function new(string name = "phy_rx_frame_err_seq");
    super.new(name);
  endfunction : new


  virtual task body();
    begin
      `uvm_info(get_type_name(), "Starting...", UVM_HIGH)
      req = phy_seq_item::type_id::create("req");

      start_item(req);
      assert (req.randomize() with {req.trans == RX;
                                    req.err_inj inside {PHY_ERR_RX_VECTOR,
                                                        FORMAT_VIOLATION,
                                                        UNSUPPORTED_RATE};});

      `uvm_info(get_type_name(), $sformatf("The inserted error type is %s", req.err_inj.name()), UVM_LOW)
      req.frame = frame; // push down frame handle
      finish_item(req);
    end
  endtask : body

endclass : phy_rx_frame_err_seq


`endif //PHY_RX_FRAME_ERR_SEQ_SV

