//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef PHY_AGENT_SV
`define PHY_AGENT_SV

//-----------------------------------

class phy_agent extends uvm_agent;

  phy_config    cfg;
  phy_driver    driver;
  phy_sequencer sequencer;

  `uvm_component_utils_begin(phy_agent)
    `uvm_field_object(cfg, UVM_DEFAULT)
  `uvm_component_utils_end

  function new (string name = "phy_agent", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    // Get Configuration
    if (!uvm_config_db#(phy_config)::get(this, "", "cfg", cfg)) begin
       `uvm_error(get_type_name(),"Config not set for slave agent using default is_active")
    end

    sequencer = phy_sequencer::type_id::create("sequencer",this);
    driver = phy_driver::type_id::create("driver",this);

  endfunction : build_phase


  function void connect_phase(uvm_phase phase);

    driver.cfg = cfg;
    // Connect the driver to the sequencer using TLM interface
    driver.seq_item_port.connect(sequencer.seq_item_export);
  endfunction : connect_phase

endclass : phy_agent

`endif
