//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef PHY_COMMON_SV
`define PHY_COMMON_SV


  // MAC PHY latencies
  `define TX_RF_DELAY                       0.5
  `define TX_MDM_DELAY                      2.0
  `define TX_CHAIN_DELAY                    2.5
  `define MAC_PROCESSING_DELAY              2.0
  `define TX_DELAY_TO_FIRST_PHY_RDY_OFDM    15.0
  `define TX_DELAY_TO_FIRST_PHY_RDY_MF_1_SS 33.6
  `define TX_DELAY_TO_FIRST_PHY_RDY_MF_2_SS 37.6
  `define TX_DELAY_WITH_RF_ON               0.5
  `define CCA_MDM_DELAY                     3.5
  `define RX_RF_DELAY                       0.5
  `define CCA_DELAY                         4.0
  `define RX_MDM_DELAY                      9.6
  `define RX_CHAIN_DELAY                    10.1

  //------------------------------------------------
  // predefined macros from phyVectorAC.h file
  //------------------------------------------------
  // DSS CCK
  `define SHORT_PRE  96
  `define LONG_PRE   192

  // OFDM
  `define L_STF      8
  `define L_LTF      8
  `define L_SIG      4

  `define OFDM_NON_HT_PRE  (`L_STF + `L_LTF + `L_SIG)

  `define HT_STF     4
  `define HT_LTF     4
  `define HT_SIG     8

  `define OFDM_HT_MM_PRE_BASE  (`OFDM_NON_HT_PRE + `HT_SIG + `HT_STF + `HT_LTF)

  `define HT_GF_STF  8
  `define HT_LTF1    8

  `define OFDM_HT_GF_PRE_BASE  (`HT_GF_STF + `HT_LTF1 + `HT_SIG)

  `define VHT_STF    4
  `define VHT_LTF    4
  `define VHT_SIG_A  8
  `define VHT_SIG_B  4

  `define OFDM_VHT_PRE_BASE  (`OFDM_NON_HT_PRE + `VHT_SIG_A + `VHT_STF + `VHT_SIG_B + `VHT_LTF)
  // REF IEEE Std 802.11ax/D2.0 - 2017 Table 28-12 (Timing-related constants)
  `define TRL_SIG        4
  `define THE_SIG_A      8
  `define THE_SIG_A_R   16
  `define THE_STF_T      8
  `define THE_STF_NT     4
  `define THE_LTF_1X   3.2
  `define THE_LTF_2X   6.4
  `define THE_LTF_4X  12.8
  `define THE_SIG_B      4
  `define TGI1_DATA    0.8
  `define TGI2_DATA    1.6
  `define TGI4_DATA    3.2
  `define TDFT_HE     12.8
  `define NSERVICE      16

  // HE Preamble
  `define HE_SU_PRE_BASE    (`TRL_SIG + `THE_SIG_A   + `THE_STF_NT)
  `define HE_MU_PRE_BASE    (`TRL_SIG + `THE_SIG_A   + `THE_STF_NT)
  `define HE_ER_SU_PRE_BASE (`TRL_SIG + `THE_SIG_A_R + `THE_STF_NT)
  `define HE_TB_PRE_BASE    (`TRL_SIG + `THE_SIG_A   + `THE_STF_T )

// number of clock cycles in 1us, frequency * short/long duration of symbol
// short = 3.6us, long = 4us, HE tSym = 12.8
`ifdef RW_TXRX_1X1
  `ifdef RW_NX_CHBW20
//    `ifdef RW_NX_LDPC_ENC /* 120Mhz */
//      `define    SHORT_LEN         432
//      `define    LONG_LEN          480
//    `else /* 30Mhz */
//      `define    SHORT_LEN         108
//      `define    LONG_LEN          120
//    `endif
//TODO: 120Mhz supported for now
    `define    SHORT_LEN           432
    `define    LONG_LEN            480
    `define    HE_LEN              1550
    `define    GI_LEN              200
  `elsif RW_NX_CHBW4020 /* 120Mhz */
    `define    SHORT_LEN           432
    `define    LONG_LEN            480
    `define    HE_LEN              1550
    `define    GI_LEN              200
  `elsif RW_NX_CHBW804020 /* 120Mhz */
    `ifdef RW_NX_LDPC_ENC
      `define    SHORT_LEN         432
      `define    LONG_LEN          480
    `else             /* 60Mhz */
      `define    SHORT_LEN         216
      `define    LONG_LEN          240
    `endif//RW_NX_LDPC_ENC
    `define    HE_LEN              1550
    `define    GI_LEN              200
  `endif
`endif//RW_TXRX_1X1

`ifdef RW_TXRX_2X2
  `ifdef RW_NX_CHBW20
    `ifdef RW_NX_LDPC_ENC /* 120Mhz */
      `define    SHORT_LEN         432
      `define    LONG_LEN          480
    `else /* 30Mhz */
      `define    SHORT_LEN         108
      `define    LONG_LEN          120
    `endif
  `elsif RW_NX_CHBW4020 /* 120Mhz */
    `define    SHORT_LEN           432
    `define    LONG_LEN            480
  `elsif RW_NX_CHBW804020 /* 160Mhz */
    `define    SHORT_LEN           576
    `define    LONG_LEN            640
  `endif
`endif//RW_TXRX_2X2

 // error set for reception
  typedef enum {
      NO_ERROR,
      PHY_ERR_RX_VECTOR,
      PHY_ERR_BEFORE_RX_END,
      FORMAT_VIOLATION,
      UNSUPPORTED_RATE
  } err_injection_e;

`endif// PHY_COMMON_SV
