//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef PHY_SEQ_ITEM_SV
`define PHY_SEQ_ITEM_SV


class phy_seq_item extends uvm_sequence_item;

  PPDU_frame                  frame;
  rand transaction_e          trans;        // transaction type
  rand err_injection_e        err_inj;      // Which error should appear in RX
  rand bit [31:0]             time_of_departure;
  rand bit [15:0]             time_of_departure_clk_rate;

  `uvm_object_utils_begin(phy_seq_item)
    `uvm_field_object(frame, UVM_DEFAULT)
    `uvm_field_enum(transaction_e, trans, UVM_DEFAULT)
    `uvm_field_enum(err_injection_e, err_inj, UVM_DEFAULT)
    `uvm_field_int(time_of_departure, UVM_DEFAULT)
    `uvm_field_int(time_of_departure_clk_rate, UVM_DEFAULT)
  `uvm_object_utils_end
  
  constraint err_inj_c{
    if (trans == TX)
      err_inj == NO_ERROR;
  }

  function new (string name = "phy_seq_item");
    super.new(name);

    frame = PPDU_frame::type_id::create("frame");
  endfunction : new

endclass : phy_seq_item

`endif //PHY_SEQ_ITEM_SV
