//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_PHY_COMMON_SV
`define MAC_PHY_COMMON_SV

  `define RX_END_2_RX_REQ_FALL_DELAY 0.5us

  //-----------------------------------------------
  //TX vector decomposition, used for printing only
  //-----------------------------------------------
  typedef struct packed {
    bit [15:0]   service;
    bit [3:0]    leg_rate;
    bit [11:0]   leg_length;
    bit          cont_tx;
    bit          time_of_dep_req;
    bit [2:0]    reserved;
    bit [2:0]    ntx;
    bit [7:0]    tx_pwr_level;
    bit [7:0]    antenna_set;
    bit          preamble_type;
    bit [2:0]    ch_bw;
    bit [3:0]    format_mode;
  } common_txvector_s;

  typedef struct packed {
    bit [7:0]           smm_index;
    bit [6:0]           reserved;
    bit                 trigg_rspd;
    common_txvector_s   common_part;
  } nonht_txvector_s;

  typedef struct packed {
    bit [15:0]          ht_length;
    bit                 fec_coding;
    bit [6:0]           mcs;
    bit [7:0]           smm_index;
    bit                 reserved;
    bit [1:0]           num_ext_ss;
    bit                 stbc;
    bit                 aggregation;
    bit                 gi_type;
    bit                 smoothing;
    bit                 sounding;
    common_txvector_s   common_part;
  } ht_txvector_s;

  typedef struct packed {
    bit [1:0]           user_position;
    bit [1:0]           reserved;
    bit [19:0]          ht_length;
    bit                 fec_coding;
    bit [2:0]           nss;
    bit [3:0]           mcs;
    bit [7:0]           smm_index;
  } vht_user_header_s;

  typedef struct packed {
    vht_user_header_s   user4;
    vht_user_header_s   user3;
    vht_user_header_s   user2;
    vht_user_header_s   user1;
    bit [4:0]           reserved4;
    bit [2:0]           n_user;
    bit                 reserved3;
    bit [5:0]           group_id;
    bit [8:0]           partial_aid;
    bit [1:0]           reserved2;
    bit                 doze_not_allowed;
    bit                 stbc;
    bit                 reserved1;
    bit                 gi_type;
    bit                 beamformed;
    bit                 sounding;
    common_txvector_s   common_part;
  } vht_txvector_s;

  typedef struct packed {
    bit [3:0]           spatial_reuse2;
    bit [3:0]           spatial_reuse1;
    bit                 reserved4;
    bit [6:0]           txop_duration;
    bit [1:0]           reserved3;
    bit [5:0]           bss_color;
    bit                 reserved2;
    bit                 midamble;
    bit                 doppler;
    bit [1:0]           he_ltf_type;
    bit                 dcm;
    bit                 beam_change;
    bit                 uplink_flag;
    bit [2:0]           reserved1;
    bit                 stbc;
    bit [1:0]           gi_type;
    bit                 beamformed;
    bit                 sounding;
    common_txvector_s   common_part;
  } he_common_txvector_s;

  typedef struct packed {
    bit                 reserved;
    bit [2:0]           packet_ext;
    bit [19:0]          he_length;
    bit                 fec_coding;
    bit [2:0]           nss;
    bit [3:0]           mcs;
    bit [7:0]           smm_index;
    he_common_txvector_s he_common_part;
  } he_su_txvector_s;

  typedef struct packed {
    bit [4:0]           user_position;
    bit [10:0]          staid;
    bit                 reserved;
    bit [2:0]           packet_ext;
    bit [19:0]          he_length;
    bit                 fec_coding;
    bit [2:0]           nss;
    bit [3:0]           mcs;
    bit [7:0]           smm_index;
  } he_user_header_s;

  typedef struct packed {
    he_user_header_s    user4;
    he_user_header_s    user3;
    he_user_header_s    user2;
    he_user_header_s    user1;
    bit [7:0]           n_user;
    bit [31:0]          ru_allocation;
    bit [2:0]           reserved1;
    bit [2:0]           mcs_sig_b;
    bit                 dcm_sig_b;
    bit                 sig_b_compression_mode;
    he_common_txvector_s he_common_part;
  } he_mu_txvector_s;

  typedef struct packed {
    bit                 feedback_status;
    bit [6:0]           ru_tone_set_idx;
    bit                 trigg_method;
    bit [2:0]           packet_ext;
    bit [19:0]          he_length;
    bit                 fec_coding;
    bit [2:0]           nss;
    bit [3:0]           mcs;
    bit [7:0]           smm_index;
    bit [7:0]           ru_allocation;
    bit [4:0]           reserved2;
    bit [2:0]           starting_sts_num;
    bit [1:0]           reserved1;
    bit                 ldpc_extra_symb;
    bit                 he_ltf_mode;
    bit [2:0]           num_he_ltf;
    bit [8:0]           he_siga_reserved;
    bit [3:0]           spatial_reuse4;
    bit [3:0]           spatial_reuse3;
    he_common_txvector_s he_common_part;
  } he_trigg_txvector_s;

  //-----------------------------------------------
  //RX vector decomposition, used for printing only
  //-----------------------------------------------
  typedef struct packed {
    bit [7:0]    rssi;
    bit [3:0]    leg_rate;
    bit [11:0]   leg_length;
    bit [7:0]    rssi_legacy;
    bit [7:0]    antenna_set;
    bit          preamble_type;
    bit [2:0]    ch_bw;
    bit [3:0]    format_mode;
  } common_rxvector_s;

  typedef struct packed {
    bit                 l_sig_valid;
    bit [3:0]           reserved;
    bit [1:0]           ch_bw_in_non_ht;
    bit                 dyn_bw_in_non_ht;
    common_rxvector_s   common_part;
  } nonht_rxvector_s;

  typedef struct packed {
    bit [15:0]          ht_length;
    bit                 fec_coding;
    bit [6:0]           mcs;
    bit                 l_sig_valid;
    bit [1:0]           num_ext_ss;
    bit                 stbc;
    bit                 aggregation;
    bit                 gi_type;
    bit                 smoothing;
    bit                 sounding;
    common_rxvector_s   common_part;
  } ht_rxvector_s;

  typedef struct packed {
    bit [3:0]           reserved4;
    bit [19:0]          ht_length;
    bit                 fec_coding;
    bit [2:0]           nss;
    bit [3:0]           mcs;
    bit                 reserved3;
    bit [5:0]           group_id;
    bit [8:0]           partial_aid;
    bit                 reserved2;
    bit                 first_user;
    bit                 doze_not_allowed;
    bit                 stbc;
    bit                 reserved1;
    bit                 gi_type;
    bit                 beamformed;
    bit                 sounding;
    common_rxvector_s  common_part;
  } vht_rxvector_s;

  typedef struct packed {
    bit         reserved4;
    bit [6:0]   txop_duration;
    bit [1:0]   reserved3;
    bit [5:0]   bss_color;
    bit [1:0]   reserved2;
    bit         doppler;
    bit [1:0]   he_ltf_type;
    bit         dcm;
    bit         beam_change;
    bit         uplink_flag;
    bit [2:0]   reserved1;
    bit         stbc;
    bit [1:0]   gi_type;
    bit         beamformed;
    bit         sounding;
  } common_he_rxvector_s;

  typedef struct packed {
    bit [3:0]             reserved2;
    bit [19:0]            he_length;
    bit                   fec_coding;
    bit [2:0]             nss;
    bit [3:0]             mcs;
    bit [7:0]             reserved1;
    bit [3:0]             spatial_reuse;
    bit [3:0]             pe_duration;
    common_he_rxvector_s  common_he_part;
    common_rxvector_s     common_part;
  } he_su_rxvector_s;

  typedef struct packed {
    bit [3:0]             reserved;
    bit [19:0]            he_length;
    bit                   fec_coding;
    bit [2:0]             nss;
    bit [3:0]             mcs;
    bit [2:0]             ru_size;
    bit [2:0]             mcs_sig_b;
    bit                   dcm_sig_b;
    bit                   sig_b_comp_mode;
    bit [3:0]             spatial_reuse;
    bit [3:0]             pe_duration;
    common_he_rxvector_s  common_he_part;
    common_rxvector_s     common_part;
  } he_mu_rxvector_s;

  typedef struct packed {
    bit [4:0]             reserved2;
    bit [10:0]            staid;
    bit [3:0]             reserved1;
    bit [19:0]            he_length;
    bit                   fec_coding;
    bit [2:0]             nss;
    bit [3:0]             mcs;
  } he_trig_user_header_s;

  // as AP
  typedef struct packed {
    he_trig_user_header_s user4;
    he_trig_user_header_s user3;
    he_trig_user_header_s user2;
    he_trig_user_header_s user1;
    bit [7:0]             n_user;
    bit [7:0]             reserved;
    common_he_rxvector_s  common_he_part;
    common_rxvector_s     common_part;
  } he_trig_rxvector_ap_s;

  // as STA
  typedef struct packed {
    bit [15:0]            spatial_reuse;
    common_he_rxvector_s  common_he_part;
    common_rxvector_s     common_part;
  } he_trig_rxvector_sta_s;

  // HE-NDP-TRIG
  typedef struct packed {
    bit [71:0]            ndp_report_2nd_80;
    bit [31:0]            ndp_report_2nd_40;
    bit [15:0]            ndp_report_2nd_20;
    bit [23:0]            ndp_report_1st_20;
    bit [7:0]             n_user;
    common_he_rxvector_s  common_he_part;
    common_rxvector_s     common_part;
  } he_ndp_trig_rxvector_s;

  typedef struct packed {
    bit [7:0]             evm4;
    bit [7:0]             evm3;
    bit [7:0]             evm2;
    bit [7:0]             evm1;
    bit [7:0]             rcpi4;
    bit [7:0]             rcpi3;
    bit [7:0]             rcpi2;
    bit [7:0]             rcpi1;
  } rxvector2_s;

`endif// MAC_PHY_COMMON_SV
