//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_PHY_CONFIG_SV
`define MAC_PHY_CONFIG_SV

class mac_phy_config extends uvm_object;
  /************************************/
  /* UVC configuration fields         */
  /************************************/
  uvm_active_passive_enum is_active = UVM_ACTIVE;
  bit                     has_mac_agent = 0;
  bit                     has_phy_agent = 0;
  bit                     has_coverage  = 1;
  bit                     has_checks    = 1;
  /************************************/

  /*****************************************/
  /* list of agent configurations          */
  /*****************************************/
  mac_config              m_mac_cfg;
  phy_config              m_phy_cfg;
  /*****************************************/
  duration_t              tx_frm_duration;
  PPDU_preamble_header    pre_hdr;

  `uvm_object_utils_begin(mac_phy_config)
    `uvm_field_enum(uvm_active_passive_enum, is_active, UVM_DEFAULT)
    `uvm_field_int(has_mac_agent, UVM_DEFAULT)
    `uvm_field_int(has_phy_agent, UVM_DEFAULT)
    `uvm_field_int(has_coverage, UVM_DEFAULT)
    `uvm_field_int(has_checks, UVM_DEFAULT)
    `uvm_field_int(tx_frm_duration, UVM_DEFAULT)
    `uvm_field_object(pre_hdr, UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "mac_phy_config");
    super.new(name);

    /******************************/
    /* create all configurations  */
    /******************************/
    m_mac_cfg = mac_config::type_id::create("m_mac_cfg");
    m_phy_cfg = phy_config::type_id::create("m_phy_cfg");
    /******************************/
    pre_hdr = PPDU_preamble_header::type_id::create("pre_hdr");
  endfunction

endclass : mac_phy_config

`endif
