//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_PHY_COVERAGE_SV
`define MAC_PHY_COVERAGE_SV

class mac_phy_coverage extends uvm_subscriber #(mac_phy_seq_item);

  `uvm_component_utils(mac_phy_coverage)

  mac_phy_seq_item        item;
  format_mod_e            formatMod;

  //-------------------------------------------------
  // Cover groups
  //-------------------------------------------------
  covergroup transactions_cg;
    option.per_instance = 1;
    option.auto_bin_max = 8;

    trans_cpt : coverpoint item.trans {
      bins TX = {TX};
      bins RX = {RX};
      bins RX_RIFS = {RX_RIFS};
    }

    cca_cpt : coverpoint item.cca {
      bins CCA_PRIMARY_20   = {3'b100};
      wildcard bins CCA_SECONDARY_20 = {3'b01?};
      wildcard bins CCA_SECONDARY_40 = {3'b0?1};
      bins others[] = default;
    }

    number_of_users_cpt : coverpoint item.frame.num_of_users {
      bins ONE = {1};
      bins TWO = {2};
      bins THREE = {3};
      bins FOUR = {4};
      bins NOT_SUPPORTED[] = default;
    }

  endgroup : transactions_cg

  covergroup tx_vector_cg;
    option.per_instance = 1;
    option.auto_bin_max = 20;

    //////////////////////////////////////////////////////
    ///////////// COVER POINTS DEFINITION  ///////////////
    //////////////////////////////////////////////////////

    // txPwrLevel as coverpoint with bins 0 - 7
    txPwrLevel_cpt : coverpoint item.frame.preamble_header.tx_pwr_level {
      bins TXPWR_LEVEL_0 = {3'b000};
      bins TXPWR_LEVEL_1 = {3'b001};
      bins TXPWR_LEVEL_2 = {3'b010};
      bins TXPWR_LEVEL_3 = {3'b011};
      bins TXPWR_LEVEL_4 = {3'b100};
      bins TXPWR_LEVEL_5 = {3'b101};
      bins TXPWR_LEVEL_6 = {3'b110};
      bins TXPWR_LEVEL_7 = {3'b111};
      bins OTHERS[] = default;
    }

    // chBW as coverpoint with bins 0-3
    chBW_cpt : coverpoint item.frame.preamble_header.ch_bw {
      bins HT_CBW20 = {2'b00}
      iff ((formatMod == HT_MF) || (formatMod == HT_GF));
      bins HT_CBW40 = {2'b01}
      iff ((formatMod == HT_MF) || (formatMod == HT_GF));
      bins NON_HT_CBW40 = {2'b01}
      iff (formatMod == NON_HT_DUP_OFDM);
      bins NON_HT_CBW80 = {2'b10}
      iff (formatMod == NON_HT_DUP_OFDM);
      bins NON_HT_CBW160 = {2'b11}
      iff (formatMod == NON_HT_DUP_OFDM);
      bins NON_HT_CBW20 = {2'b00}
      iff (formatMod == NON_HT);
      bins VHT_CHBW20 = {2'b00}
      iff (formatMod == VHT);
      bins VHT_CHBW40 = {2'b01}
      iff (formatMod == VHT);
      bins VHT_CHBW80 = {2'b10}
      iff (formatMod == VHT);
      bins VHT_CHBW160 = {2'b11}
      iff (formatMod == VHT);
    }

    // smoothing as coverpoint with bins 0,1
    smoothing_cpt : coverpoint item.frame.preamble_header.smoothing {
      bins SMOOTHING_0 = {0};
      bins SMOOTHING_1 = {1} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
    }

    // antennaSet as coverpoint with bins 0 - 256
    antennaSet_cpt : coverpoint item.frame.preamble_header.antenna_set {
      wildcard bins ANTENNASET_1 = {8'b???????1};
      wildcard bins ANTENNASET_2 = {8'b??????1?};
      wildcard bins ANTENNASET_3 = {8'b?????1??};
      wildcard bins ANTENNASET_4 = {8'b????1???};
      bins OTHERS[] = default;
    }

    // smmIndex as coverpoint with bins 0 - 256
    smmIndex_cpt : coverpoint item.frame.preamble_header.user_header[0].smm_index_f {
      bins DIRECT_MAPPING   = {0};
      bins INDIRECT_MAPPING = {[1:2]};
      bins SMMINDEX_BFM     = {[128:255]};
      bins OTHERS[] = default;
    }

    // mcs as coverpoint with bins
    mcs_cpt : coverpoint item.frame.preamble_header.user_header[0].mcs_f
              iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM) {
      bins MCS_0  = {0 };
      bins MCS_1  = {1 };
      bins MCS_2  = {2 };
      bins MCS_3  = {3 };
      bins MCS_4  = {4 };
      bins MCS_5  = {5 };
      bins MCS_6  = {6 };
      bins MCS_7  = {7 };
      bins MCS_8  = {8 };
      bins MCS_9  = {9 };
      bins MCS_10 = {10};
      bins MCS_11 = {11};
      bins MCS_12 = {12};
      bins MCS_13 = {13};
      bins MCS_14 = {14};
      bins MCS_15 = {15};
      bins MCS_32 = {32};
      bins OTHERS[] = default;
    }

    // preType as coverpoint with bins 0,1
    preType_cpt : coverpoint item.frame.preamble_header.preamble_type {
      bins SHORT_PREAMBLE = {0};
      bins LONG_PREAMBLE = {1};
    }

    // formatMod as coverpoint with bins NON_HT,NON_HT_DUP_OFDM,
    // HT_MF,HT_GF, VHT
    formatMod_cpt : coverpoint formatMod {
      bins NON_HT = {NON_HT};
      bins NON_HT_DUP_OFDM = {NON_HT_DUP_OFDM};
      bins HT_MF = {HT_MF};
      bins HT_GF = {HT_GF};
      bins VHT   = {VHT};
    }

    // numExtnSS as coverpoint with bins 0 - 3
    numExtnSS_cpt : coverpoint item.frame.preamble_header.num_extn_ss {
      bins NUM_EXTN_SS_0 = {0};
      bins NUM_EXTN_SS_1 = {1} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
      bins NUM_EXTN_SS_2 = {2} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
      bins NUM_EXTN_SS_3 = {3} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
    }

    // stbc as coverpoint with bins 0 - 3
    //~ stbc_cpt : coverpoint item.frame.preamble_header.stbc {
      //~ bins NO_STBC = {2'b00};
      //~ bins NSTS_NSS_1 = {2'b01} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
      //~ bins NSTS_NSS_2 = {2'b10} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
      //~ bins RSVD = {2'b11} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
    //~ }

    // sounding as coverpoint with bins 0,1
    sounding_cpt : coverpoint item.frame.preamble_header.sounding {
      bins SOUNDING = {1} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
      bins NOT_SOUNDING = {0};
    }

    // legLength as coverpoint with bins min length to max length
    legLength_cpt : coverpoint item.frame.preamble_header.leg_length {
      bins LESS_THAN_24 = {[0:24]};
      bins BW_25_100 = {[25:100]};
      bins BW_100_500 = {[100:500]};
      bins BW_500_1000 = {[500:1000]};
      bins OTHERS[] = default;
    }

    // legRate as coverpoint with bins 0-F
    legRate_cpt : coverpoint item.frame.preamble_header.leg_rate {
      bins MBPS_1  = {4'b0000};
      bins MBPS_2  = {4'b0001};
      bins MBPS_55 = {4'b0010};
      bins MBPS_11 = {4'b0011};
      bins MBPS_6  = {4'b1011};
      bins MBPS_9  = {4'b1111};
      bins MBPS_12 = {4'b1010};
      bins MBPS_18 = {4'b1110};
      bins MBPS_24 = {4'b1001};
      bins MBPS_36 = {4'b1101};
      bins MBPS_48 = {4'b1000};
      bins MBPS_54 = {4'b1100};
      bins RSVD = {4'b0100,4'b0101,4'b0110,4'b0111};
      bins MBPS_1_11 = {[4'b0000:4'b0011]};
    }

    // service as coverpoint
    service_cpt : coverpoint item.frame.preamble_header.service {
      bins OTHERS[] = default;
    }

    // htLength as coverpoint with bins min length to max length
    htLength_cpt : coverpoint item.frame.preamble_header.user_header[0].ht_length_f
                   iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM) {
      bins LESS_THAN_24 = {[0:24]};
      bins BW_25_100 = {[25:100]};
      bins BW_100_500 = {[100:500]};
      bins BW_500_1000 = {[500:1000]};
      bins OTHERS[] = default;
    }

    // nTxPT as coverpoint with bins 0 - 3
    nTx_cpt : coverpoint item.frame.preamble_header.num_tx {
      bins NTX_1 = {0};
      bins NTX_2 = {1};
      bins OTHERS[] = default;
    }

    // shortGI as coverpoint with bins 0,1
    shortGI_cpt : coverpoint item.frame.preamble_header.gi_type[0] {
      bins SHORT_GI = {1} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
      bins LONG_GI = {0};
    }

    aggregation_cpt : coverpoint item.frame.preamble_header.aggregated {
      bins AGGREGATED = {1};
      bins NOT_AGGREGATED = {0};
    }

    // fecCoding as coverpoint with bins 0,1
    fecCoding_cpt : coverpoint item.frame.preamble_header.user_header[0].fec_coding_f {
      bins FEC_CODING_1 = {1} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
      bins FEC_CODING_0 = {0};
    }

    // current operating mode as coverpoint
    abgn_mode_cpt : coverpoint item.frame.preamble_header.abgn_mode {
      bins MODE_802_11B         = {MODE_802_11B       };
      bins MODE_802_11A         = {MODE_802_11A       };
      bins MODE_802_11G         = {MODE_802_11G       };
      bins MODE_802_11N_2_4GHZ  = {MODE_802_11N_2_4GHZ};
      bins MODE_802_11N_5GHZ    = {MODE_802_11N_5GHZ  };
      bins MODE_802_11AC        = {MODE_802_11AC      };
    }

    doze_not_allowed_cpt : coverpoint item.frame.preamble_header.doze_not_allowed
                           iff (formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM) {
      bins DOZE_ALLOWED = {1};
      bins DOZE_NOT_ALLOWED = {0};
    }

    beamformed_cpt : coverpoint item.frame.preamble_header.beamformed
                     iff (formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM) {
      bins BEAMFORMED = {1};
      bins NOT_BEAMFORMED = {0};
    }

    partial_aid_cpt : coverpoint item.frame.preamble_header.partial_aid
                      iff (formatMod == VHT) {
      bins  BSSID_RA = {[0:511]} iff (item.frame.preamble_header.group_id == 0);
      bins  AP_2_STA = {[0:511]} iff (item.frame.preamble_header.group_id == 63);
      bins  NOT_PRESENT[] = default;
    }

    group_id_cpt : coverpoint item.frame.preamble_header.group_id
                   iff (formatMod == VHT) {
      bins  MU_MIMO = { [1:62] };
      bins  SU_MIMO = { 0, 63 };
    }

    ////////////////////////////////////////////////////////////////////////////
    ///////////////////////////// CROSS DEFINITION /////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    // Cross of formatMod and shortGI
    formatMod_shortGI_cr : cross formatMod_cpt,shortGI_cpt {
      // HT and VHT only, LM doesn't support ShortGI
      ignore_bins  formatMod_shortGI_cr_0 = binsof(formatMod_cpt.NON_HT);
      ignore_bins  formatMod_shortGI_cr_1 = binsof(formatMod_cpt.NON_HT_DUP_OFDM );
    }

    // Cross of formatMod and fecCoding
    formatMod_fecCoding_cr : cross formatMod_cpt,fecCoding_cpt {
      // HT and VHT only, LM doesn't support LDPC
      ignore_bins  formatMod_fecCoding_cr_0 = binsof(formatMod_cpt.NON_HT);
      ignore_bins  formatMod_fecCoding_cr_1 = binsof(formatMod_cpt.NON_HT_DUP_OFDM );
    }

    // Cross of preType_cpt and legRate_cpt
    preType_legRate_cr : cross preType_cpt,legRate_cpt {

      ignore_bins preType_legRate_cr_0 = binsof(legRate_cpt.MBPS_1);
      ignore_bins preType_legRate_cr_1 = binsof(legRate_cpt.MBPS_2);
      ignore_bins preType_legRate_cr_2 = binsof(legRate_cpt.MBPS_55);
      ignore_bins preType_legRate_cr_3 = binsof(legRate_cpt.MBPS_11);
      ignore_bins preType_legRate_cr_4 = binsof(legRate_cpt.MBPS_6);
      ignore_bins preType_legRate_cr_5 = binsof(legRate_cpt.MBPS_9);
      ignore_bins preType_legRate_cr_6 = binsof(legRate_cpt.MBPS_12);
      ignore_bins preType_legRate_cr_7 = binsof(legRate_cpt.MBPS_18);
      ignore_bins preType_legRate_cr_8 = binsof(legRate_cpt.MBPS_24);
      ignore_bins preType_legRate_cr_9 = binsof(legRate_cpt.MBPS_36);
      ignore_bins preType_legRate_cr_10 = binsof(legRate_cpt.MBPS_48);
      ignore_bins preType_legRate_cr_11 = binsof(legRate_cpt.MBPS_54);
      ignore_bins preType_legRate_cr_12 = binsof(legRate_cpt.RSVD);

    }

  endgroup : tx_vector_cg

  covergroup rx_vector_cg;
    option.per_instance = 1;
    option.auto_bin_max = 20;

    //////////////////////////////////////////////////////
    ///////////// COVER POINTS DEFINITION  ///////////////
    //////////////////////////////////////////////////////

    // chBW as coverpoint with bins 0-3
    chBW_cpt : coverpoint item.frame.preamble_header.ch_bw {
      bins HT_CBW20 = {2'b00}
      iff ((formatMod == HT_MF) || (formatMod == HT_GF));
      bins HT_CBW40 = {2'b01}
      iff ((formatMod == HT_MF) || (formatMod == HT_GF));
      bins NON_HT_CBW40 = {2'b01}
      iff (formatMod == NON_HT_DUP_OFDM);
      bins NON_HT_CBW80 = {2'b10}
      iff (formatMod == NON_HT_DUP_OFDM);
      bins NON_HT_CBW160 = {2'b11}
      iff (formatMod == NON_HT_DUP_OFDM);
      bins NON_HT_CBW20 = {2'b00}
      iff (formatMod == NON_HT);
      bins VHT_CHBW20 = {2'b00}
      iff (formatMod == VHT);
      bins VHT_CHBW40 = {2'b01}
      iff (formatMod == VHT);
      bins VHT_CHBW80 = {2'b10}
      iff (formatMod == VHT);
      bins VHT_CHBW160 = {2'b11}
      iff (formatMod == VHT);
    }

    // smoothing as coverpoint with bins 0,1
    smoothing_cpt : coverpoint item.frame.preamble_header.smoothing {
      bins SMOOTHING_0 = {0};
      bins SMOOTHING_1 = {1} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
    }

    // antennaSet as coverpoint with bins 0 - 256
    antennaSet_cpt : coverpoint item.frame.preamble_header.antenna_set {
      wildcard bins ANTENNASET_1 = {8'b???????1};
      wildcard bins ANTENNASET_2 = {8'b??????1?};
      wildcard bins ANTENNASET_3 = {8'b?????1??};
      wildcard bins ANTENNASET_4 = {8'b????1???};
      bins OTHERS[] = default;
    }

    // mcs as coverpoint with bins
    mcs_cpt : coverpoint item.frame.preamble_header.user_header[0].mcs_f
              iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM) {
      bins MCS_0  = {0 };
      bins MCS_1  = {1 };
      bins MCS_2  = {2 };
      bins MCS_3  = {3 };
      bins MCS_4  = {4 };
      bins MCS_5  = {5 };
      bins MCS_6  = {6 };
      bins MCS_7  = {7 };
      bins MCS_8  = {8 };
      bins MCS_9  = {9 };
      bins MCS_10 = {10};
      bins MCS_11 = {11};
      bins MCS_12 = {12};
      bins MCS_13 = {13};
      bins MCS_14 = {14};
      bins MCS_15 = {15};
      bins MCS_32 = {32};
      bins OTHERS[] = default;
    }

    // preType as coverpoint with bins 0,1
    preType_cpt : coverpoint item.frame.preamble_header.preamble_type {
      bins SHORT_PREAMBLE = {0};
      bins LONG_PREAMBLE = {1};
    }

    // formatMod as coverpoint with bins NON_HT,NON_HT_DUP_OFDM,
    // HT_MF,HT_GF, VHT
    formatMod_cpt : coverpoint formatMod {
      bins NON_HT = {NON_HT};
      bins NON_HT_DUP_OFDM = {NON_HT_DUP_OFDM};
      bins HT_MF = {HT_MF};
      bins HT_GF = {HT_GF};
      bins VHT   = {VHT};
    }

    // numExtnSS as coverpoint with bins 0 - 3
    numExtnSS_cpt : coverpoint item.frame.preamble_header.num_extn_ss {
      bins NUM_EXTN_SS_0 = {0};
      bins NUM_EXTN_SS_1 = {1} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
      bins NUM_EXTN_SS_2 = {2} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
      bins NUM_EXTN_SS_3 = {3} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
    }

    //~ // stbc as coverpoint with bins 0 - 3
    //~ stbc_cpt : coverpoint item.frame.preamble_header.stbc {
      //~ bins NO_STBC = {2'b00};
      //~ bins NSTS_NSS_1 = {2'b01} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
      //~ bins NSTS_NSS_2 = {2'b10} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
      //~ bins RSVD = {2'b11} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
    //~ }

    // sounding as coverpoint with bins 0,1
    sounding_cpt : coverpoint item.frame.preamble_header.sounding {
      bins SOUNDING = {1} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
      bins NOT_SOUNDING = {0};
    }

    // legLength as coverpoint with bins min length to max length
    legLength_cpt : coverpoint item.frame.preamble_header.leg_length {
      bins LESS_THAN_24 = {[0:24]};
      bins BW_25_100 = {[25:100]};
      bins BW_100_500 = {[100:500]};
      bins BW_500_1000 = {[500:1000]};
      bins OTHERS[] = default;
    }

    // legRate as coverpoint with bins 0-F
    legRate_cpt : coverpoint item.frame.preamble_header.leg_rate {
      bins MBPS_1 = {4'b0000};
      bins MBPS_2 = {4'b0001};
      bins MBPS_55 = {4'b0010};
      bins MBPS_11 = {4'b0011};
      bins MBPS_6 = {4'b1011};
      bins MBPS_9 = {4'b1111};
      bins MBPS_12 = {4'b1010};
      bins MBPS_18 = {4'b1110};
      bins MBPS_24 = {4'b1001};
      bins MBPS_36 = {4'b1101};
      bins MBPS_48 = {4'b1000};
      bins MBPS_54 = {4'b1100};
      bins RSVD = {4'b0100,4'b0101,4'b0110,4'b0111};
      bins MBPS_1_11 = {[4'b0000:4'b0011]};
    }

    // htLength as coverpoint with bins min length to max length
    htLength_cpt : coverpoint item.frame.preamble_header.user_header[0].ht_length_f
                   iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM) {
      bins LESS_THAN_24 = {[0:24]};
      bins BW_25_100 = {[25:100]};
      bins BW_100_500 = {[100:500]};
      bins BW_500_1000 = {[500:1000]};
      bins OTHERS[] = default;
    }

    // shortGI as coverpoint with bins 0,1
    shortGI_cpt : coverpoint item.frame.preamble_header.gi_type[0] {
      bins SHORT_GI = {1} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
      bins LONG_GI = {0};
    }

    aggregation_cpt : coverpoint item.frame.preamble_header.aggregated {
      bins AGGREGATED = {1};
      bins NOT_AGGREGATED = {0};
    }

    // fecCoding as coverpoint with bins 0,1
    fecCoding_cpt : coverpoint item.frame.preamble_header.user_header[0].fec_coding_f {
      bins FEC_CODING_1 = {1} iff(formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM);
      bins FEC_CODING_0 = {0};
    }

    // current operating mode as coverpoint
    abgn_mode_cpt : coverpoint item.frame.preamble_header.abgn_mode {
      bins MODE_802_11B         = {MODE_802_11B       };
      bins MODE_802_11A         = {MODE_802_11A       };
      bins MODE_802_11G         = {MODE_802_11G       };
      bins MODE_802_11N_2_4GHZ  = {MODE_802_11N_2_4GHZ};
      bins MODE_802_11N_5GHZ    = {MODE_802_11N_5GHZ  };
      bins MODE_802_11AC        = {MODE_802_11AC      };
    }

    doze_not_allowed_cpt : coverpoint item.frame.preamble_header.doze_not_allowed
                           iff (formatMod != NON_HT && formatMod != NON_HT_DUP_OFDM) {
      bins DOZE_ALLOWED = {1};
      bins DOZE_NOT_ALLOWED = {0};
    }

    partial_aid_cpt : coverpoint item.frame.preamble_header.partial_aid
                      iff (formatMod == VHT) {
      bins  BSSID_RA = {[0:511]} iff (item.frame.preamble_header.group_id == 0);
      bins  AP_2_STA = {[0:511]} iff (item.frame.preamble_header.group_id == 63);
      bins  NOT_PRESENT[] = default;
    }

    group_id_cpt : coverpoint item.frame.preamble_header.group_id
                   iff (formatMod == VHT) {
      bins  MU_MIMO = { [1:62] };
      bins  SU_MIMO = { 0, 63 };
    }

    l_sig_valid_cpt : coverpoint item.frame.preamble_header.l_sig_valid
                      iff (formatMod == HT_MF) {
      bins L_SIG_VALID = {1};
      bins L_SIG_NOT_VALID = {0};
    }

    chbw_in_non_ht_cpt : coverpoint item.frame.preamble_header.chbw_in_non_ht
                         iff (formatMod == NON_HT || formatMod == NON_HT_DUP_OFDM) {
      bins NON_HT_CBW20 = {2'b00};
      bins NON_HT_CBW40 = {2'b01};
      bins NON_HT_CBW80 = {2'b10};
      bins NON_HT_CBW160 = {2'b11};
    }

    dyn_bw_cpt : coverpoint item.frame.preamble_header.dyn_bw {
      bins STATIC_BANDWIDTH_OP = {0};
      bins DYNAMIC_BANDWIDTH_OP = {1};
    }

    // first user parameter is valid in MU_MIMO
    first_user_cpt : coverpoint item.frame.preamble_header.first_user
                     iff (item.frame.preamble_header.group_id inside {[1:62]}){
      bins FIRST_USER = {1};
      bins NOT_FIRST = {0};
    }

    rcpi_cpt : coverpoint item.frame.preamble_header.rcpi[0] {
      bins POWER_MINUS_110DBM_0DBM = {[0:220]};
      bins RSVD = {[221:254]};
      bins MEAS_NOT_AVAILABLE = {255};
    }

    ////////////////////////////////////////////////////////////////////////////
    ///////////////////////////// CROSS DEFINITION /////////////////////////////
    ////////////////////////////////////////////////////////////////////////////

    // Cross of formatMod and shortGI
    formatMod_shortGI_cr : cross formatMod_cpt,shortGI_cpt;

    // Cross of formatMod and fecCoding
    formatMod_fecCoding_cr : cross formatMod_cpt,fecCoding_cpt;

    // Cross of preType_cpt and legRate_cpt
    preType_legRate_cr : cross preType_cpt,legRate_cpt {

      ignore_bins preType_legRate_cr_0 = binsof(legRate_cpt.MBPS_1);
      ignore_bins preType_legRate_cr_1 = binsof(legRate_cpt.MBPS_2);
      ignore_bins preType_legRate_cr_2 = binsof(legRate_cpt.MBPS_55);
      ignore_bins preType_legRate_cr_3 = binsof(legRate_cpt.MBPS_11);
      ignore_bins preType_legRate_cr_4 = binsof(legRate_cpt.MBPS_6);
      ignore_bins preType_legRate_cr_5 = binsof(legRate_cpt.MBPS_9);
      ignore_bins preType_legRate_cr_6 = binsof(legRate_cpt.MBPS_12);
      ignore_bins preType_legRate_cr_7 = binsof(legRate_cpt.MBPS_18);
      ignore_bins preType_legRate_cr_8 = binsof(legRate_cpt.MBPS_24);
      ignore_bins preType_legRate_cr_9 = binsof(legRate_cpt.MBPS_36);
      ignore_bins preType_legRate_cr_10 = binsof(legRate_cpt.MBPS_48);
      ignore_bins preType_legRate_cr_11 = binsof(legRate_cpt.MBPS_54);
      ignore_bins preType_legRate_cr_12 = binsof(legRate_cpt.RSVD);

    }

  endgroup : rx_vector_cg

  //----------------------------------------------------------------
  // end coverage
  //----------------------------------------------------------------

  function new(string name = "mac_phy_coverage", uvm_component parent = null);
    super.new(name, parent);

    tx_vector_cg = new();
    rx_vector_cg = new();
    transactions_cg = new();
  endfunction : new

  function void write(mac_phy_seq_item t);
    item = t;
    // assigning new variable for manipulation with shorter name
    formatMod = item.frame.preamble_header.format_mod;

    if (item.trans == TX)
      tx_vector_cg.sample();
    else
      rx_vector_cg.sample();

    transactions_cg.sample();
  endfunction : write

endclass : mac_phy_coverage

`endif //MAC_PHY_COVERAGE_SV
