//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_PHY_ENV_SV
`define MAC_PHY_ENV_SV

//-----------------------------------

class mac_phy_env extends uvm_env;
  `uvm_component_utils(mac_phy_env)

  mac_phy_config            m_cfg;
  mac_phy_virtual_sequencer m_vsqr;
  mac_agent                 m_mac_agent;
  phy_agent                 m_phy_agent;
  mac_phy_coverage          m_coverage;
  mac_phy_monitor           m_monitor;


  function new (string name = "mac_phy_env", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    // Get configuration
    if (!uvm_config_db #(mac_phy_config)::get(this, "", "mac_phy_config", m_cfg))
      `uvm_error(get_type_name(), "MAC-PHY configuration not set in configuration DB!!!")

    // Create components
    if (m_cfg.is_active == UVM_ACTIVE)
      m_vsqr = mac_phy_virtual_sequencer::type_id::create("m_vsqr", this);

    m_monitor = mac_phy_monitor::type_id::create("m_monitor", this);
    m_monitor.cfg = m_cfg;


    if (m_cfg.is_active == UVM_ACTIVE) begin
      if (m_cfg.has_mac_agent) begin
        uvm_config_db #(mac_config)::set(this, "m_mac_agent", "cfg", m_cfg.m_mac_cfg);
        m_mac_agent = mac_agent::type_id::create("m_mac_agent", this);
      end

      if (m_cfg.has_phy_agent) begin
        uvm_config_db #(phy_config)::set(this, "m_phy_agent", "cfg", m_cfg.m_phy_cfg);
        m_phy_agent = phy_agent::type_id::create("m_phy_agent", this);
      end
    end// UVM_ACTIVE

    if (m_cfg.has_coverage) begin
      m_coverage = mac_phy_coverage::type_id::create("m_coverage", this);
    end

  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);

    if (m_cfg.has_coverage) begin
      m_monitor.ap.connect(m_coverage.analysis_export);
    end

    /* connect environment components and handles */
    if (m_cfg.has_mac_agent) begin
      m_vsqr.m_mac_sqr = m_mac_agent.sequencer;
    end // has_mac_agent

    if (m_cfg.has_phy_agent) begin
      m_vsqr.m_phy_sqr = m_phy_agent.sequencer;
    end // has_phy_agent

  endfunction : connect_phase

endclass : mac_phy_env

`endif //MAC_PHY_ENV_SV
