//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_PHY_IF_SV
`define MAC_PHY_IF_SV

interface mac_phy_if;

  `include "uvm_macros.svh"
  import uvm_pkg::*;

  // Check flags
  bit             has_checks = 1;
  bit             has_coverage = 1;

  // signal declaration
  logic           clk;
  logic           rst_n;
  // MAC to PHY signals
  logic           tx_req;
  logic           rx_req;
  logic [7:0]     tx_data;        // Used in combination with tx_data_uid
  logic [7:0]     tx_data_uid;
  logic           mac_data_valid;
  logic           mimo_cmd_valid;
  logic           keep_rf_on;
  // PHY to MAC signals
  logic           phy_rdy;        // 4 ready signals for 4 user
  logic           tx_end;
  logic [7:0]     rx_data;
  logic           cca_primary_20;
  logic           cca_secondary_20;
  logic           cca_secondary_40;
  logic           rx_end_for_timing;
  logic           rx_err;
  logic           rx_end;
  logic           phy_err;
  logic           rifs_rx_detected;
  logic [7:0]     rx_data_uid;

endinterface : mac_phy_if

`endif
