//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_PHY_RX_STREAM_SEQ_ITEM_SV
`define MAC_PHY_RX_STREAM_SEQ_ITEM_SV


class mac_phy_rx_stream_seq_item extends uvm_sequence_item;

  format_mod_e              format_mod;
  nonht_rxvector_s          nonht_rxv;
  ht_rxvector_s             ht_rxv;
  vht_rxvector_s            vht_rxv;
  he_su_rxvector_s          he_su_rxv;
  he_mu_rxvector_s          he_mu_rxv;
  he_trig_rxvector_sta_s    he_tb_sta_rxv;
  he_trig_rxvector_ap_s     he_tb_ap_rxv;
  octet_t                   rx_vector_end[8];
  octet_t                   rx_stream[];
  bit                       no_valid_frames;

  `uvm_object_utils_begin(mac_phy_rx_stream_seq_item)
    `uvm_field_sarray_int(rx_vector_end, UVM_DEFAULT)
    `uvm_field_array_int(rx_stream, UVM_DEFAULT)
    `uvm_field_int(no_valid_frames, UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "mac_phy_rx_stream_seq_item");
    super.new(name);
  endfunction : new

  function void do_copy(uvm_object rhs);
    mac_phy_rx_stream_seq_item rhs_;

    if (!$cast(rhs_,rhs)) begin
      `uvm_fatal(get_type_name(), "do_copy cast failed!")
    end
    super.do_copy(rhs);

    format_mod     = rhs_.format_mod;
    nonht_rxv      = rhs_.nonht_rxv;
    ht_rxv         = rhs_.ht_rxv;
    vht_rxv        = rhs_.vht_rxv;
    he_su_rxv      = rhs_.he_su_rxv;
    he_mu_rxv      = rhs_.he_mu_rxv;
    he_tb_sta_rxv  = rhs_.he_tb_sta_rxv;
    he_tb_ap_rxv   = rhs_.he_tb_ap_rxv;

    foreach (rx_vector_end[i])
      rx_vector_end[i] = rhs_.rx_vector_end[i];

    rx_stream = new[rhs_.rx_stream.size()];
    foreach (rx_stream[i])
      rx_stream[i] = rhs_.rx_stream[i];

    no_valid_frames = rhs_.no_valid_frames;
  endfunction : do_copy

  virtual function void do_print(uvm_printer printer);
    super.do_print(printer);

    case (format_mod)
      NON_HT, NON_HT_DUP_OFDM : printer.print_string("NON HT RXVEC", $sformatf("%p",nonht_rxv));
      HT_MF, HT_GF            : printer.print_string("HT RXVEC"    , $sformatf("%p",ht_rxv));
      VHT                     : printer.print_string("VHT RXVEC"   , $sformatf("%p",vht_rxv));
      HE_SU, HE_EXT_SU        : printer.print_string("HE SU RXVEVC", $sformatf("%p",he_su_rxv));
      HE_MU                   : printer.print_string("HE MU RXVEC" , $sformatf("%p",he_mu_rxv));
      HE_TB                   : printer.print_string("HE TB RXVEC" , $sformatf("%p",he_tb_sta_rxv));
    endcase
  endfunction : do_print

endclass : mac_phy_rx_stream_seq_item

`endif //MAC_PHY_RX_STREAM_SEQ_ITEM_SV
