//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MAC_PHY_SEQ_ITEM_SV
`define MAC_PHY_SEQ_ITEM_SV


class mac_phy_seq_item extends uvm_sequence_item;

  PPDU_frame       frame;        // PPDU frame collected
  transaction_e    trans;        // transaction type
  bit              phy_err;      // PHY error occured
  bit              rx_err;       // Rx error occured
  bit              rx_end_for_timing; // end of Rx frame on air
  bit [2:0]        cca;          // bits: 2 - primary 20
                                 //       1 - secondary 20
                                 //       0 - secondary 40
  //timestamps for frame
  time             rx_req_rise;
  time             tx_req_rise;
  time             start_of_frame;
  time             end_of_frame;

  `uvm_object_utils_begin(mac_phy_seq_item)
    `uvm_field_object(frame, UVM_DEFAULT | UVM_NOCOPY)
    `uvm_field_enum(transaction_e, trans, UVM_DEFAULT)
    `uvm_field_int(phy_err, UVM_DEFAULT)
    `uvm_field_int(rx_err, UVM_DEFAULT)
    `uvm_field_int(rx_end_for_timing, UVM_DEFAULT)
    `uvm_field_int(cca, UVM_DEFAULT)
    `uvm_field_int(rx_req_rise, UVM_DEFAULT)
    `uvm_field_int(tx_req_rise, UVM_DEFAULT)
    `uvm_field_int(start_of_frame, UVM_DEFAULT)
    `uvm_field_int(end_of_frame, UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "mac_phy_seq_item");
    super.new(name);

    frame = PPDU_frame::type_id::create("frame");
    // create default container frame for monitor to store collected data
    assert (frame.randomize() with { frame.kind == SINGLETON;
                                     frame.ppdu_format == NON_HT;
                                     frame.num_of_users == 1;
                                   });
  endfunction : new

  function void do_copy(uvm_object rhs);
    mac_phy_seq_item rhs_;

    if (!$cast(rhs_,rhs)) begin
      `uvm_fatal(get_type_name(), "do_copy cast failed!")
    end
    super.do_copy(rhs);

    frame.copy(rhs_.frame);
    trans               = rhs_.trans;
    phy_err             = rhs_.phy_err;
    rx_err              = rhs_.rx_err;
    rx_end_for_timing   = rhs_.rx_end_for_timing;
    cca                 = rhs_.cca;
    rx_req_rise         = rhs_.rx_req_rise;
    tx_req_rise         = rhs_.tx_req_rise;
    start_of_frame      = rhs_.start_of_frame;
    end_of_frame        = rhs_.end_of_frame;
  endfunction : do_copy

endclass : mac_phy_seq_item

`endif //MAC_PHY_SEQ_ITEM_SV
