//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MEM_READ_SEQ_SV
`define MEM_READ_SEQ_SV


class mem_read_seq extends mem_seq_base;

  // nymber of symbols to be read
  int unsigned  read_nsymb;
  // frame format mode
  format_mod_e  format_mod;
  // RU type
  ru_type_e     ru_type;
  // HE-LTF-TYPE
  bit [1:0]     he_ltf_type; //needed for HE frames
  // Channel bandwidth
  bit [2:0]     ch_bw;
  // Number of HE-LTF
  int           num_he_ltf;
  // Number of SIGB in HE-MU
  int           num_he_sig_b;
  // DUT location, to determine which RU is used
  int           dut_location;

  `uvm_object_utils(mem_read_seq)


  function new (string name = "mem_read_seq");
    super.new (name);
  endfunction : new

  virtual task body();
    begin
      `uvm_info(get_type_name(), "Starting read from memory", UVM_HIGH)
      req = mem_seq_item#(WIDTH)::type_id::create("req");

      start_item(req);
      assert (req.randomize() with {
        read_nsymb  == local::read_nsymb;
        format_mod  == local::format_mod;
        ru_type     == local::ru_type;
        he_ltf_type == local::he_ltf_type;
        ch_bw       == local::ch_bw;
        num_he_ltf  == local::num_he_ltf;
        num_he_sig_b== local::num_he_sig_b;
        dut_location== local::dut_location;
      });
      finish_item(req);
    end
  endtask : body

endclass : mem_read_seq


`endif //MEM_READ_SEQ_SV
