//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MEM_WRITE_SEQ_SV
`define MEM_WRITE_SEQ_SV


class mem_write_seq extends mem_seq_base;

  fft_data_array   fft_in_data;
  // frame format mode
  format_mod_e  format_mod;
  // HE-LTF-TYPE
  bit [1:0]     he_ltf_type; //needed for HE frames
  int           num_he_ltf;
  int           num_he_sig_b;
  bit [1:0]     gi_type;
  bit [2:0]     ch_bw;
  int           dut_location;

  `uvm_object_utils(mem_write_seq)


  function new (string name = "mem_write_seq");
    super.new (name);
  endfunction : new

  virtual task body();
    begin
      `uvm_info(get_type_name(), "Starting write from memory", UVM_HIGH)
      req = mem_seq_item#(WIDTH)::type_id::create("req");

      start_item(req);
      assert (req.randomize() with {
        format_mod   == local::format_mod;
        he_ltf_type  == local::he_ltf_type;
        num_he_ltf   == local::num_he_ltf;
        num_he_sig_b == local::num_he_sig_b;
        gi_type      == local::gi_type;
        ch_bw        == local::ch_bw;
        dut_location == local::dut_location;
      });
      req.fft_in_data = fft_in_data;
      finish_item(req);
    end
  endtask : body

endclass : mem_write_seq


`endif //MEM_WRITE_SEQ_SV
