//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MEM_CONFIG_SV
`define MEM_CONFIG_SV

class mem_config extends uvm_object;

  uvm_active_passive_enum        is_active = UVM_ACTIVE;
  bit                            is_read_mem  = 1; // if 0 then agent is write mem
  bit                            has_coverage = 1;
  bit                            has_checks   = 1;

  `uvm_object_utils_begin(mem_config)
    `uvm_field_enum(uvm_active_passive_enum, is_active, UVM_DEFAULT)
    `uvm_field_int(is_read_mem, UVM_DEFAULT)
    `uvm_field_int(has_coverage, UVM_DEFAULT)
    `uvm_field_int(has_checks, UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "mem_config");
    super.new(name);
  endfunction

endclass : mem_config

`endif
