//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MEM_IF_SV
`define MEM_IF_SV

interface mem_if #(int WIDTH = 8);

  `include "uvm_macros.svh"
  import uvm_pkg::*;

  // Check flags
  bit   has_checks = 1;
  bit   has_coverage = 1;
  // is read/write interface active, needed  because
  // of signal forcing during wiring
  bit   is_read_active = 0;
  bit   is_write_active = 0;

  // control signal declaration
  logic                clk;    // clock
  logic                rst_n;  // reset, active low
  logic                start;
  logic                enable;
  logic                dir;
  logic [2:0]          sel;
  logic                done;
  // memory write signals
  logic signed [12:0]  wpi;    // real part primary
  logic signed [12:0]  wpq;    // imag part primary
  logic signed [12:0]  wsi;    // real part secondary
  logic signed [12:0]  wsq;    // imag part secondary
  logic                wen;    // write enable
  logic                wsel;
  logic [9:0]          windex;
  logic [2:0]          wlen;
  logic [3:0]          wscale;
  // memory read signals
  logic signed [12:0]  ri;     // real part
  logic signed [12:0]  rq;     // imag part
  logic                rps;    // primary - 0, secondary - 1
  logic                ren;    // read enable
  logic                rsel;
  logic [9:0]          rindex;
  logic [2:0]          rlen;
  logic                rvalid;
  logic                last;
  // MISC signals
  logic [15:0]         symb_cnt; // count number of symbols in frame
  logic                td_done;

  /***************************/
  /* ASSERTIONS              */
  /***************************/

  property symb_cnt_x_check_prop;
  @(posedge clk)
    disable iff(rst_n == 0 || has_checks == 0)
    !$isunknown(symb_cnt);
  endproperty

  SYMB_CNT_X_CHECK: assert property (symb_cnt_x_check_prop) else
    `uvm_error("ASSERT_ERR", "'X' value appeared on the symb_cnt")

  /***************************/
  /* COVERAGE                */
  /***************************/

endinterface : mem_if

`endif
