//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MEM_SEQ_ITEM_SV
`define MEM_SEQ_ITEM_SV


class mem_seq_item#(int WIDTH = 8) extends uvm_sequence_item;

  // collected write/read samples
  FFT_data_s         fft_data[int];     // primary channel
  FFT_data_s         fft_data_sec[int]; // secondary channel
  // nymber of symbols to be read
  rand int unsigned  read_nsymb;
  // frame format mode
  rand format_mod_e  format_mod;
  // RU type
  rand ru_type_e     ru_type;
  // HE-LTF-TYPE
  rand bit [1:0]     he_ltf_type; //needed for HE frames
  // samples for FFT input, all symbols
  fft_data_array     fft_in_data;
  // Number of HE LTF fields
  rand int           num_he_ltf;
  // Number of HE-SIG-B fields
  rand int           num_he_sig_b;
  // GI type
  rand bit [1:0]     gi_type;
  // Channel BW
  rand bit [2:0]     ch_bw;
  rand int           dut_location;

  `uvm_object_param_utils_begin(mem_seq_item#(WIDTH))
  `uvm_object_utils_end

  function new (string name = "mem_seq_item");
    super.new(name);
  endfunction : new

  function void do_print(uvm_printer printer);
    super.do_print(printer);

    foreach (fft_data[i])
      printer.print_string("FFT samples - primary:",$sformatf("[%0d] %p",i,FFT2string(fft_data[i])));
    foreach (fft_data_sec[i])
      printer.print_string("FFT samples - secondary:",$sformatf("[%0d] %p",i,FFT2string(fft_data_sec[i])));
  endfunction : do_print

endclass : mem_seq_item

`endif //MEM_SEQ_ITEM_SV
