//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_STREAM_GEN_NOISE_SEQ_SV
`define MODEM_STREAM_GEN_NOISE_SEQ_SV

class modem_stream_gen_noise_seq#(int WIDTH=`ADCWIDTH) extends modem_stream_seq_base#(WIDTH);

  `uvm_object_utils(modem_stream_gen_noise_seq)

  bit               stop_noise        = 0;               // set to 1 to stop
                                                         // noise immediatelly
  rf_gpio_t         rf_gpio           =`GPIO_WIDTH'd27;  // from PHY RTL
  integer           noise_sample_num  = 0;               // number of samples
                                                         // to send
  string            noise_file_name = "./noise_0dB.txt"; // file containing
                                                         // noise samples
  bit               adc_disabled = 0;                    // set to 1 when RTL disables ADC IF

  // local variables
  local integer                   sample_count;
  local integer                   noise_file;
  local real                      norm_noise_i;
  local real                      norm_noise_q;
  local integer                   v_status;
  local bit [`NOISE_BUFF_SIZE:0]  v_line;

  function new(string name = "modem_stream_gen_noise_seq");
    super.new(name);
  endfunction : new

  virtual task body();
    begin
      `uvm_info(get_type_name(), "Starting ADC noise...", UVM_HIGH)

      noise_file  = $fopen(noise_file_name,"rb");

      if(!noise_file) begin
        `uvm_fatal(get_type_name(), $sformatf("Unable to open noise file %s", noise_file_name))
      end else begin
        `uvm_info(get_type_name(), $sformatf("Succesfully opened noise file %s", noise_file_name), UVM_HIGH)
      end

      sample_count = 0;

      do begin
        req = modem_stream_seq_item#(WIDTH)::type_id::create("req");
        use_response_handler(1);
        start_item(req);
        req.last_adc_sample = 1'b0;
        req.data_valid      = 1'b0;

        if($feof(noise_file)) begin
          v_status = $rewind(noise_file);
        end

        // read noise data from file
        v_status = $fgets(v_line,noise_file);
        v_status = $sscanf(v_line,"%f %f",norm_noise_i,norm_noise_q);

        // default Rx gain in RIU
        norm_noise_i = norm_noise_i * ({26'd0, rf_gpio[5:0]} +'d5);
        norm_noise_q = norm_noise_q * ({26'd0, rf_gpio[5:0]} +'d5);
        `uvm_info(get_type_name(),
        $sformatf("norm_noise_i = %f norm_noise_q = %f rf_gpio = %0d", norm_noise_i, norm_noise_q, rf_gpio), UVM_DEBUG)

        req.DataI0 = $rtoi(norm_noise_i);
        req.DataQ0 = $rtoi(norm_noise_q);

`ifdef RW_TXRX_2X2
        req.DataI1 = $rtoi(norm_noise_i);
        req.DataQ1 = $rtoi(norm_noise_q);
`endif

        finish_item(req);
        sample_count++;
      end while ((stop_noise != 1'b1) && ((noise_sample_num == 0) ? 1'b1 : (sample_count < noise_sample_num)));

      `uvm_info(get_type_name(),
      $sformatf("Noise stopped stop_noise = %0d  adc_disabled = %0d sample_count = %0d noise_sample_num = %0d",
      stop_noise, adc_disabled, sample_count, noise_sample_num), UVM_DEBUG)

      $fclose(noise_file);

      `uvm_info(get_type_name(), "Stoping ADC noise...", UVM_HIGH)

    end
  endtask : body

  function void response_handler (uvm_sequence_item response);
    modem_stream_seq_item#(WIDTH) rsp;
    if (!$cast(rsp, response)) begin
      `uvm_fatal(get_type_name(), $sformatf("Failed cast from 'response' to 'rhs'"))
    end
    adc_disabled = rsp.phy_disabled_adc;
  endfunction: response_handler

endclass : modem_stream_gen_noise_seq


`endif //MODEM_STREAM_GEN_NOISE_SEQ_SV
