//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_STREAM_GEN_SAMPLES_SEQ_SV
`define MODEM_STREAM_GEN_SAMPLES_SEQ_SV

class modem_stream_gen_samples_seq#(int WIDTH=`ADCWIDTH) extends modem_stream_seq_base#(WIDTH);

  `uvm_object_utils(modem_stream_gen_samples_seq)

  ADC_mu_data_t RFdata_re [];
  ADC_mu_data_t RFdata_im [];

  bit adc_disabled = 0;
  bit timeout_occured = 0;

  function new(string name = "modem_stream_gen_samples_seq");
    super.new(name);
  endfunction : new


  virtual task body();
    begin
      `uvm_info(get_type_name(), "Starting...", UVM_HIGH)
      for( int i = `IQCountOffset; i< (RFdata_re.size()/`RW_NX_DERIV_NRX)-`IQCountOffset; i++) begin
        // stop trying to send samples once PHY disables ADC IF
        if (adc_disabled == 'b1) begin
          `uvm_info(get_type_name(), "ADC IF has been disabled by RTL!", UVM_HIGH)
          break;
        end
        else if (timeout_occured == 1'b1) begin
          `uvm_info(get_type_name(), "AGC timeout occured, stop ADC samples", UVM_HIGH)
          break;
        end

        req = modem_stream_seq_item#(WIDTH)::type_id::create("req");
        use_response_handler(1);
        start_item(req);
        req.last_adc_sample = 1'b0;
        req.data_valid      = 1'b1;

        req.DataI0 = RFdata_re[i][0];
        req.DataQ0 = RFdata_im[i][0];
`ifdef RW_TXRX_2X2
        req.DataI1 = RFdata_re[i][1];
        req.DataQ1 = RFdata_im[i][1];
`endif
        finish_item(req);
      end

      if (adc_disabled == 'b0 || timeout_occured == 1'b1) begin
        req = modem_stream_seq_item#(WIDTH)::type_id::create("req");
        start_item(req);
        req.last_adc_sample = 1'b1;
        req.data_valid      = 1'b0;
        finish_item(req);
      end
    end
  endtask : body


  function void response_handler (uvm_sequence_item response);
    modem_stream_seq_item#(WIDTH) rsp;
    if (!$cast(rsp, response)) begin
      `uvm_fatal(get_type_name(), $sformatf("Failed cast from 'response' to 'rhs'"))
    end
    adc_disabled = rsp.phy_disabled_adc;
  endfunction: response_handler

endclass : modem_stream_gen_samples_seq


`endif //MODEM_STREAM_GEN_SAMPLES_SEQ_SV
