//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_STREAM_AGENT_SV
`define MODEM_STREAM_AGENT_SV

//-----------------------------------

class modem_stream_agent#(int WIDTH = 8) extends uvm_agent;

  modem_stream_config            cfg;
  modem_stream_driver  #(WIDTH)  driver;
  modem_stream_monitor #(WIDTH)  monitor;
  modem_stream_coverage#(WIDTH)  coverage;
  modem_stream_sequencer#(WIDTH) sequencer;

  `uvm_component_param_utils_begin(modem_stream_agent#(WIDTH))
    `uvm_field_object(cfg, UVM_DEFAULT)
  `uvm_component_utils_end

  function new (string name = "modem_stream_agent", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    // Get Configuration
    if (!uvm_config_db#(modem_stream_config)::get(this, "", "cfg", cfg)) begin
       `uvm_fatal(get_type_name(), "Config not set for slave agent using default is_active")
    end

    // Create components
    monitor = modem_stream_monitor#(WIDTH)::type_id::create("monitor",this);
    monitor.cfg = cfg;
    if (cfg.has_coverage) begin
      coverage = modem_stream_coverage#(WIDTH)::type_id::create("coverage", this);
    end

    if (cfg.is_active == UVM_ACTIVE) begin
      sequencer = modem_stream_sequencer#(WIDTH)::type_id::create("sequencer",this);
      driver = modem_stream_driver#(WIDTH)::type_id::create("driver",this);
    end

  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    if (cfg.has_coverage) begin
      monitor.ap.connect(coverage.analysis_export);
    end

    if (cfg.is_active == UVM_ACTIVE) begin
      driver.cfg = cfg;
      // Connect the driver to the sequencer using TLM interface
      driver.seq_item_port.connect(sequencer.seq_item_export);
    end
  endfunction : connect_phase

endclass : modem_stream_agent

`endif
