//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_STREAM_CONFIG_SV
`define MODEM_STREAM_CONFIG_SV

class modem_stream_config extends uvm_object;

  uvm_active_passive_enum        is_active = UVM_ACTIVE;
  bit                            is_stream_agent = 0; // used for pure stream agent collecting data
  bit                            buffer_mode_on = 0;  // used for collecting data in buffering mode
  bit                            symb_end_on_last = 0;  // used for collecting data with last signal triggering the end of sampling
  bit                            has_coverage = 1;
  bit                            has_checks   = 1;


  `uvm_object_utils_begin(modem_stream_config)
    `uvm_field_enum(uvm_active_passive_enum, is_active, UVM_DEFAULT)
    `uvm_field_int(is_stream_agent, UVM_DEFAULT)
    `uvm_field_int(has_coverage, UVM_DEFAULT)
    `uvm_field_int(has_checks, UVM_DEFAULT)
  `uvm_object_utils_end


  function new (string name = "modem_stream_config");
    super.new(name);
  endfunction

endclass : modem_stream_config

`endif
