//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_STREAM_COVERAGE_SV
`define MODEM_STREAM_COVERAGE_SV

class modem_stream_coverage#(int WIDTH = 8) extends uvm_subscriber #(modem_stream_seq_item#(WIDTH));

  `uvm_component_param_utils(modem_stream_coverage#(WIDTH))

  modem_stream_seq_item #(WIDTH) item;

  //-------------------------------------------------
  // Cover groups
  //-------------------------------------------------
  covergroup modem_stream_active_cg(string name) ;
    option.per_instance = 1;
    option.name = name;

    DataI0_cpt : coverpoint item.DataI0 {
      option.auto_bin_max = 20;
    }

    DataQ0_cpt : coverpoint item.DataQ0 {
      option.auto_bin_max = 20;
    }

    DataI1_cpt : coverpoint item.DataI1 {
      option.auto_bin_max = 20;
    }

    DataQ1_cpt : coverpoint item.DataQ1 {
      option.auto_bin_max = 20;
    }

  endgroup : modem_stream_active_cg

  function new(string name = "modem_stream_coverage", uvm_component parent = null);
    super.new(name, parent);
    modem_stream_active_cg = new(name);
  endfunction : new

  function void write(modem_stream_seq_item#(WIDTH) t);
    item = t;
    modem_stream_active_cg.sample();
  endfunction : write

endclass : modem_stream_coverage

`endif //MODEM_STREAM_COVERAGE_SV
