//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_STREAM_IF_SV
`define MODEM_STREAM_IF_SV

interface modem_stream_if #(int DATA_WIDTH = 8);

  // Check flags
  bit   has_checks = 1;
  bit   has_coverage = 1;

  // signal declaration
  logic                        clk;    // clock
  logic                        rst_n;  // reset, active low
  logic                        data_valid;  // for ADC indicates data is on IF and not noise or for stream sampling
  logic                        data_ready;  // for stream sampling
  logic                        data_last;   // for stream sampling
  logic [DATA_WIDTH-1:0]       data;        // for stream sampling

  // for ADC/DAC
  logic signed [DATA_WIDTH-1:0] DataI0; // Antenna 0 real data part
  logic signed [DATA_WIDTH-1:0] DataQ0; // Antenna 0 imaginary data part
  logic                         DataEn0;
  logic                         On0;
  logic signed [DATA_WIDTH-1:0] DataI1; // Antenna 1 real data part
  logic signed [DATA_WIDTH-1:0] DataQ1; // Antenna 1 imaginary data part
  logic                         DataEn1;
  logic                         On1;


  /***************************/
  /* ASSERTIONS              */
  /***************************/

  /***************************/
  /* COVERAGE                */
  /***************************/

endinterface : modem_stream_if

`endif
