//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_STREAM_MONITOR_SV
`define MODEM_STREAM_MONITOR_SV


class modem_stream_monitor#(int WIDTH = 8) extends uvm_monitor;

  virtual modem_stream_if #(WIDTH) vif;
  modem_stream_config              cfg;
  uvm_analysis_port #(modem_stream_seq_item#(WIDTH)) ap;

  `uvm_component_param_utils(modem_stream_monitor#(WIDTH))

  function new(string name = "modem_stream_monitor", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual modem_stream_if#(WIDTH))::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

    ap = new("ap", this);
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    wait (vif.rst_n == 1'b1);

    fork
      collect_transaction();
      /* add some task calls here */
    join_none
  endtask : run_phase


  task collect_transaction();
    forever begin

      modem_stream_seq_item#(WIDTH) item = modem_stream_seq_item#(WIDTH)::type_id::create("item");
      void'(begin_tr(item));
      fork
        if (cfg.is_stream_agent)
          collect_stream_data(item);
        else
          collect_channel(item);
      join

      `uvm_info(get_type_name(), $sformatf("Transaction collected :\n%s", item.sprint()), UVM_FULL)

      if (cfg.has_checks)
        perform_checks();

      ap.write(item);
      end_tr(item);
    end// forever
  endtask : collect_transaction

  task collect_channel(ref modem_stream_seq_item#(WIDTH) item);
    bit item_collected;
    item_collected = 'b0;
    do begin
      wait (vif.On0 && vif.DataEn0);
`ifdef RW_TXRX_2X2
      wait (vif.On1 && vif.DataEn1);
`endif

      @(negedge vif.clk);
      if (vif.On0 === 'b1 && vif.DataEn0 === 'b1) begin
        item.DataI0 = vif.DataI0;
        item.DataQ0 = vif.DataQ0;
        item.dac0_data_err = 'b0;
        item_collected = 'b1;
      end else if (vif.On0 === 'b0 && vif.DataEn0 === 'b1) begin
        item.DataI0 = vif.DataI0;
        item.DataQ0 = vif.DataQ0;
        item.dac0_data_err = 'b1;
        item_collected = 'b1;
      end
`ifdef RW_TXRX_2X2
      if (vif.On1 === 'b1 && vif.DataEn1 === 'b1) begin
        item.DataI1 = vif.DataI1;
        item.DataQ1 = vif.DataQ1;
        item.dac1_data_err = 'b0;
        item_collected = 'b1;
      end else if (vif.On1 === 'b0 && vif.DataEn1 === 'b1) begin
        item.DataI1 = vif.DataI1;
        item.DataQ1 = vif.DataQ1;
        item.dac1_data_err = 'b1;
        item_collected = 'b1;
      end
`endif
    end while (item_collected == 'b0);
  endtask: collect_channel

  task collect_stream_data(ref modem_stream_seq_item#(WIDTH) item);
    if (cfg.buffer_mode_on == 0) begin
      @(posedge vif.clk iff (vif.data_valid && vif.data_ready));
      item.stream_data = vif.data;
    end
    else if (cfg.symb_end_on_last == 1) begin
      forever begin
        @(posedge vif.clk iff (vif.data_valid && vif.data_ready) or negedge (vif.data_last));
        if (vif.data_valid == 1'b1) begin
          item.buffered_data = new[item.buffered_data.size()+1](item.buffered_data);
          item.buffered_data[item.buffered_data.size - 1] = vif.data;
          if (vif.data_last == 1) begin
            wait(vif.data_valid == 0);
            break;
          end
        end // if
        else begin
          // when data is not valid anymore, send
          // the buffered data to scbd
          if(item.buffered_data.size() > 0)
            break;
        end // else
      end // forever
    end // else
    else begin
      forever begin
        @(posedge vif.clk iff (vif.data_valid && vif.data_ready) or negedge (vif.data_valid));
        if (vif.data_valid == 1'b1) begin
          item.buffered_data = new[item.buffered_data.size()+1](item.buffered_data);
          item.buffered_data[item.buffered_data.size - 1] = vif.data;
        end // if
        else begin
          // when data is not valid anymore, send
          // the buffered data to scbd
          break;
        end // else
      end // forever
    end // else
  endtask : collect_stream_data

  function void perform_checks();
  endfunction : perform_checks

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase


endclass : modem_stream_monitor

`endif //MODEM_STREAM_MONITOR_SV
