//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef MODEM_STREAM_SEQ_ITEM_SV
`define MODEM_STREAM_SEQ_ITEM_SV


class modem_stream_seq_item#(int WIDTH = 8) extends uvm_sequence_item;

  bit signed [WIDTH-1:0]  DataI0; // Antenna 0 real data part
  bit signed [WIDTH-1:0]  DataQ0; // Antenna 0 imaginary data part

  bit signed [WIDTH-1:0]  DataI1; // Antenna 0 real data part
  bit signed [WIDTH-1:0]  DataQ1; // Antenna 0 imaginary data part

  bit                     last_adc_sample;  // set to 1 to indicate last ADC sample for driver
  bit                     data_valid;       // set to 1 to indicate last ADC has data and not noise
  bit                     phy_disabled_adc; // set to 1 to indicate PHY RTL disabled ADC (reception complete)

  bit                     dac0_data_err;    // set to 1 to inicate that On0 on DAC IF has dropped
                                            // to 0 before DataEn0

  bit                     dac1_data_err;    // set to 1 to inicate that On1 on DAC IF has dropped
                                            // to 0 before DataEn1

  // collected data sample when pure stream agent is used
  logic [WIDTH-1:0]         stream_data;
  logic [WIDTH-1:0]         buffered_data[];

  `uvm_object_param_utils_begin(modem_stream_seq_item#(WIDTH))
    `uvm_field_int(DataI0, UVM_DEFAULT)
    `uvm_field_int(DataQ0, UVM_DEFAULT)
    `uvm_field_int(DataI1, UVM_DEFAULT)
    `uvm_field_int(DataQ1, UVM_DEFAULT)
    `uvm_field_int(last_adc_sample, UVM_DEFAULT)
    `uvm_field_int(data_valid, UVM_DEFAULT)
    `uvm_field_int(dac0_data_err, UVM_DEFAULT)
    `uvm_field_int(dac1_data_err, UVM_DEFAULT)
    `uvm_field_int(stream_data, UVM_DEFAULT)
    `uvm_field_array_int(buffered_data, UVM_DEFAULT)
  `uvm_object_utils_end


  function new (string name = "modem_stream_seq_item");
    super.new(name);
  endfunction : new

  function void do_copy(uvm_object rhs);
    modem_stream_seq_item#(WIDTH) rhs_;

    if (!$cast(rhs_,rhs)) begin
      `uvm_fatal(get_type_name(), "do_copy cast failed!")
    end
    super.do_copy(rhs);

    DataI0 = rhs_.DataI0; 
    DataQ0 = rhs_.DataQ0; 
    DataI1 = rhs_.DataI1; 
    DataQ1 = rhs_.DataQ1; 
    last_adc_sample = rhs_.last_adc_sample;  
    data_valid = rhs_.data_valid;       
    phy_disabled_adc = rhs_.phy_disabled_adc; 
    dac0_data_err = rhs_.dac0_data_err;    
    dac1_data_err = rhs_.dac1_data_err;    
    stream_data = rhs_.stream_data;

    buffered_data = new[rhs_.buffered_data.size()];
    foreach(rhs_.buffered_data[i]) buffered_data[i] = rhs_.buffered_data[i];
    
  endfunction : do_copy

endclass : modem_stream_seq_item

`endif //MODEM_STREAM_SEQ_ITEM_SV
