//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef PTA_WLAN_COVERAGE_SV
`define PTA_WLAN_COVERAGE_SV

class pta_wlan_coverage extends uvm_subscriber #(pta_wlan_seq_item);

  `uvm_component_utils(pta_wlan_coverage)

  pta_wlan_seq_item item;

  //-------------------------------------------------
  // Cover groups
  //-------------------------------------------------
  covergroup pta_wlan_cg(string name);
    option.per_instance = 1;
    option.name = name;

    COMMAND : coverpoint item.cmd;
    ABORT_TX: coverpoint item.wlan_tx_abort;
    ABORT_RX: coverpoint item.wlan_rx_abort;
  endgroup : pta_wlan_cg


  function new(string name = "pta_wlan_coverage", uvm_component parent = null);
    super.new(name, parent);

    pta_wlan_cg = new(name);
  endfunction : new

  function void write(pta_wlan_seq_item t);
    item = t;
    pta_wlan_cg.sample();
  endfunction : write

endclass : pta_wlan_coverage

`endif //PTA_WLAN_COVERAGE_SV
