//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef PTA_WLAN_MONITOR_SV
`define PTA_WLAN_MONITOR_SV


class pta_wlan_monitor extends uvm_monitor;

  virtual pta_wlan_if vif;
  pta_wlan_config     cfg;
  uvm_analysis_port #(pta_wlan_seq_item) ap;

  `uvm_component_utils(pta_wlan_monitor)

  function new(string name = "pta_wlan_monitor", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual pta_wlan_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

    ap = new("ap", this);
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    fork
      collect_transaction();
      observe_reset();
      /* add some task calls here */
    join_none;
  endtask : run_phase


  task observe_reset();
  endtask : observe_reset


  task collect_transaction();
    pta_wlan_seq_item item = pta_wlan_seq_item::type_id::create("item");
    `uvm_info(get_type_name(),"Start collecting signal values from the interface", UVM_HIGH)
    forever begin

      fork : COLLECT_TRANS
        begin
          @(posedge vif.wlan_tx);
          item.cmd = WLAN_SET_TX;
        end
        begin
          @(posedge vif.wlan_rx);
          item.cmd = WLAN_SET_RX;
        end
        begin
          @(vif.wlan_tx_abort);
          if (vif.wlan_tx_abort == 1) begin
            item.wlan_tx_abort = 1;
          end
          else begin
            item.wlan_tx_abort = 0;
          end
          item.cmd = WLAN_TX_ABORT;
        end
        begin
          @(vif.wlan_rx_abort);
          if (vif.wlan_rx_abort) begin
            item.wlan_rx_abort = 1;
          end
          else begin
            item.wlan_rx_abort = 0;
          end
          item.cmd = WLAN_RX_ABORT;
        end
        begin
          wait (item.sig_value[`WLAN_PTI] != vif.wlan_pti);
        end
        begin
          @(vif.wlan_pti_tog)
          item.cmd = WLAN_SET_PTI;
        end
        begin
          wait (item.sig_value[`WLAN_CHAN_FREQ] != vif.wlan_chan_freq);
          item.cmd = WLAN_SET_CHAN_FREQ;
        end
        begin
          @(vif.wlan_chan_bw);
          item.cmd = WLAN_SET_CHAN_BW;
        end
        begin
          @(vif.wlan_chan_offset);
          item.cmd = WLAN_SET_CHAN_OFFSET;
        end
      join_any

      item.sig_value[`WLAN_TX         ] = vif.wlan_tx         ;
      item.sig_value[`WLAN_RX         ] = vif.wlan_rx         ;
      item.sig_value[`WLAN_PTI_TOG    ] = vif.wlan_pti_tog    ;
      item.sig_value[`WLAN_PTI        ] = vif.wlan_pti        ;
      item.wlan_tx_abort                = vif.wlan_tx_abort   ;
      item.wlan_rx_abort                = vif.wlan_rx_abort   ;
      item.sig_value[`WLAN_CHAN_FREQ  ] = vif.wlan_chan_freq  ;
      item.sig_value[`WLAN_CHAN_BW    ] = vif.wlan_chan_bw    ;
      item.sig_value[`WLAN_CHAN_OFFSET] = vif.wlan_chan_offset;

      if (cfg.has_checks)
        perform_checks();

      `uvm_info(get_type_name(), $sformatf("Transaction collected :\n%s", item.sprint()), UVM_HIGH)
      ap.write(item);
    end// forever
  endtask : collect_transaction


  function void perform_checks();
  endfunction : perform_checks

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase


endclass : pta_wlan_monitor

`endif //PTA_WLAN_MONITOR_SV
