//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RADIO_CTRL_CONFIG_SV
`define RADIO_CTRL_CONFIG_SV

class radio_ctrl_config extends uvm_object;

  uvm_active_passive_enum        is_active = UVM_ACTIVE;
  bit                            has_coverage = 1;
  bit                            has_checks   = 1;

  bit         spi_ss_pol = 0;   // SPI slave select polarity: 0 - active low, 1 - active high
  bit         spi_cpol   = 0;   // SPI clock polarity: 0 - clock idle state is 0; 1 - clock idle state is 1
  bit         spi_cpha   = 0;   // SPI clock edge sample: 0 - sample on first edge; 1 - sample on second edge
  spi_role_e  spi_role = SLAVE; // SPI role for agent, MASTER (generates clk, ss, MOSI) or SLAVE (generates only MISO)

  bit [`GPIO_WIDTH-1:0] karst_gain;       // Current value of AGC control (rf_gpio port value)
  bit                   karst_gain_valid; // Indicates if karst_gain is valid
  bit [`AGCC_WIDTH-1:0] AGCCount;         // AGC sample count @80MHz

  // cpol = cpha = 0 ensures data is captured on rising edge of clock and output on falling

  `uvm_object_utils_begin(radio_ctrl_config)
    `uvm_field_enum(uvm_active_passive_enum, is_active, UVM_DEFAULT)
    `uvm_field_int(has_coverage, UVM_DEFAULT)
    `uvm_field_int(has_checks, UVM_DEFAULT)
    `uvm_field_int(spi_ss_pol, UVM_DEFAULT)
    `uvm_field_int(spi_cpol, UVM_DEFAULT)
    `uvm_field_int(spi_cpha, UVM_DEFAULT)
    `uvm_field_int(karst_gain, UVM_DEFAULT)
    `uvm_field_int(karst_gain_valid, UVM_DEFAULT)
    `uvm_field_int(AGCCount, UVM_DEFAULT)
    `uvm_field_enum(spi_role_e, spi_role, UVM_DEFAULT)
  `uvm_object_utils_end


  function new (string name = "radio_ctrl_config");
    super.new(name);
  endfunction

endclass : radio_ctrl_config

`endif
