//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RADIO_CTRL_COVERAGE_SV
`define RADIO_CTRL_COVERAGE_SV

class radio_ctrl_coverage extends uvm_subscriber #(radio_ctrl_seq_item);

  `uvm_component_utils(radio_ctrl_coverage)

  radio_ctrl_seq_item item;

  //-------------------------------------------------
  // Cover groups
  //-------------------------------------------------
    //TODO add covergroups
  covergroup radio_ctrl_active_cg(string name) ;
    option.per_instance = 1;
    option.name = name;

    trans_cpt : coverpoint item.item_kind {

      bins SPI        = {SPI};
      bins GPIO       = {GPIO};
      bins RESET      = {RESET};
      bins AGCFREEZE  = {AGCFREEZE};
      bins TESTMODE   = {TESTMODE};
      bins TXRXSWITCH = {TXRXSWITCH};
      bins EXTPACTRL  = {EXTPACTRL};
    }

    spi_data_miso_cpt : coverpoint item.spi_data_miso
                        iff (item.item_kind == SPI) {
      option.auto_bin_max = 20;
    }

    spi_data_mosi_cpt : coverpoint item.spi_data_mosi
                        iff (item.item_kind == SPI) {
      option.auto_bin_max = 20;
    }

    gpio_cpt : coverpoint item.gpio
               iff (item.item_kind == GPIO) {
      option.auto_bin_max = 20;
    }

    resetn_cpt : coverpoint item.resetn
                 iff (item.item_kind == RESET) {
      bins RESET_0 = {0};
      bins RESET_1 = {1};
    }

    agcfreeze_cpt : coverpoint item.agcfreeze
                    iff (item.item_kind == AGCFREEZE) {
      bins AGCFREEZE_0 = {0};
      bins AGCFREEZE_1 = {1};
    }

    tmode_cpt : coverpoint item.tmode
                iff (item.item_kind == TESTMODE) {
      bins TESTMODE_0 = {0};
      bins TESTMODE_1 = {1};
    }

    txrxsw0_cpt : coverpoint item.trsw0
                  iff (item.item_kind == TXRXSWITCH) {
      bins TXRXSWITCH0_0 = {0};
      bins TXRXSWITCH0_1 = {1};
    }

    txrxsw1_cpt : coverpoint item.trsw1
                  iff (item.item_kind == TXRXSWITCH) {
      bins TXRXSWITCH1_0 = {0};
      bins TXRXSWITCH1_1 = {1};
    }

    extpaon_ch0_5G9_cpt : coverpoint item.extpaon_ch0_5G9
                          iff (item.item_kind == EXTPACTRL) {
      bins EXTPAON_CH0_5G9_0 = {0};
      bins EXTPAON_CH0_5G9_1 = {1};
    }

    extpaon_ch0_2G4_cpt : coverpoint item.extpaon_ch0_2G4
                          iff (item.item_kind == EXTPACTRL) {
      bins EXTPAON_CH0_2G4_0 = {0};
      bins EXTPAON_CH0_2G4_1 = {1};
    }

    extpaon_ch1_5G9_cpt : coverpoint item.extpaon_ch1_5G9
                          iff (item.item_kind == EXTPACTRL) {
      bins EXTPAON_CH1_5G9_0 = {0};
      bins EXTPAON_CH1_5G9_1 = {1};
    }

    extpaon_ch1_2G4_cpt : coverpoint item.extpaon_ch1_2G4
                          iff (item.item_kind == EXTPACTRL) {
      bins EXTPAON_CH1_2G4_0 = {0};
      bins EXTPAON_CH1_2G4_1 = {1};
    }

  endgroup : radio_ctrl_active_cg

  function new(string name = "radio_ctrl_coverage", uvm_component parent = null);
    super.new(name, parent);
    radio_ctrl_active_cg = new(name);
  endfunction : new

  function void write(radio_ctrl_seq_item t);
    item = t;
    radio_ctrl_active_cg.sample();
  endfunction : write

endclass : radio_ctrl_coverage

`endif //RADIO_CTRL_COVERAGE_SV
