//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RADIO_CTRL_DRIVER_SV
`define RADIO_CTRL_DRIVER_SV


class radio_ctrl_driver extends uvm_driver #(radio_ctrl_seq_item);

  `uvm_component_utils(radio_ctrl_driver)

  virtual radio_ctrl_if vif;
  radio_ctrl_config     cfg;


  function new (string name = "radio_ctrl_driver", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual radio_ctrl_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    fork
      get_and_drive();
      /* add other tasks here */
    join_none;
  endtask : run_phase

  task initialize();
    if (cfg.spi_role == MASTER) begin
      vif.spi_ss_n        <= ~cfg.spi_ss_pol;
      vif.spi_clk         <= 'b0;
      vif.spi_mosi        <= 'b0;
    end else begin
      vif.spi_miso        <= 'b0;
    end
/*
    vif.gpio            <= 'b0;
    vif.resetn          <= 'b1;
    vif.agcfreeze       <= 'b0;
    vif.tmode           <= 'b0;
    vif.trsw0           <= 'b0;
    vif.trsw1           <= 'b0;
    vif.extpaon_ch0_5G9 <= 'b0;
    vif.extpaon_ch0_2G4 <= 'b0;
    vif.extpaon_ch1_5G9 <= 'b0;
    vif.extpaon_ch1_2G4 <= 'b0;*/
  endtask : initialize


  task get_and_drive();
    initialize();

    forever begin
      seq_item_port.get_next_item(req);
      `uvm_info(get_type_name(), "Start of bus cycle detected.", UVM_MEDIUM)
      `uvm_info(get_type_name(), $sformatf("Transaction received :\n%s", req.sprint()), UVM_HIGH)

      case (req.item_kind)
        SPI         : drive_spi(req);
        GPIO        : drive_gpio(req);
        RESET       : drive_resetn(req);
        AGCFREEZE   : drive_agcfreeze(req);
        TESTMODE    : drive_testmode(req);
        TXRXSWITCH  : drive_txrxsw(req);
        EXTPACTRL   : drive_extpactrl(req);
      endcase

      seq_item_port.item_done();

    end // forever
  endtask : get_and_drive

// -----------------------------------------------------------
// Wait on edge of clock for data reception
// -----------------------------------------------------------
  task spi_in_wait_clk_edge();
    if  ( ((cfg.spi_cpol == 0) && (cfg.spi_cpha == 1)) || ((cfg.spi_cpol == 1) && (cfg.spi_cpha == 0)) ) begin
      `uvm_info(get_type_name(), $sformatf("Waiting for clock faling edge (cpol: %1d cpha: %1d", cfg.spi_cpol, cfg.spi_cpha), UVM_HIGH)
      @(negedge vif.spi_clk);
    end else begin
      `uvm_info(get_type_name(), $sformatf("Waiting for clock rising edge (cpol: %1d cpha: %1d", cfg.spi_cpol, cfg.spi_cpha), UVM_HIGH)
      @(posedge vif.spi_clk);
    end
  endtask: spi_in_wait_clk_edge

// -----------------------------------------------------------
// Wait on edge of clock for data transmission
// -----------------------------------------------------------
  task spi_out_wait_clk_edge();
    if  ( ((cfg.spi_cpol == 0) && (cfg.spi_cpha == 1)) || ((cfg.spi_cpol == 1) && (cfg.spi_cpha == 0)) ) begin
      `uvm_info(get_type_name(), $sformatf("Waiting for clock rising edge (cpol: %1d cpha: %1d", cfg.spi_cpol, cfg.spi_cpha), UVM_HIGH)
      @(posedge vif.spi_clk);
    end else begin
      `uvm_info(get_type_name(), $sformatf("Waiting for clock faling edge (cpol: %1d cpha: %1d", cfg.spi_cpol, cfg.spi_cpha), UVM_HIGH)
      @(negedge vif.spi_clk);
    end
  endtask: spi_out_wait_clk_edge

// -----------------------------------------------------------
// Drive SPI
// -----------------------------------------------------------
  task drive_spi(radio_ctrl_seq_item req);
    bit [`SPI_DATA_WIDTH-1:0] spi_mask;
    spi_mask = 1 << (`SPI_DATA_WIDTH-1);
    if (cfg.spi_role == SLAVE) begin
      wait (vif.spi_ss_n == cfg.spi_ss_pol);
      for (int i=0; i< `SPI_DATA_WIDTH; i++) begin
        spi_out_wait_clk_edge();
        vif.spi_miso = (req.spi_data_miso & spi_mask) ? 1'b1 : 1'b0;
        spi_mask >>= 1;
      end
    end else begin
      vif.spi_ss_n <= cfg.spi_ss_pol;
      for (int i=0; i< `SPI_DATA_WIDTH; i++) begin
        spi_out_wait_clk_edge();
        vif.spi_mosi <= (req.spi_data_mosi & spi_mask) ? 1'b1 : 1'b0;
        spi_mask >>= 1;
      end
      spi_out_wait_clk_edge();
      vif.spi_ss_n <= ~cfg.spi_ss_pol;
    end
  endtask: drive_spi

  task drive_gpio(radio_ctrl_seq_item req);
    vif.gpio <= req.gpio;
  endtask: drive_gpio

  task drive_resetn(radio_ctrl_seq_item req);
    vif.resetn <= req.resetn;
  endtask: drive_resetn

  task drive_agcfreeze(radio_ctrl_seq_item req);
    vif.agcfreeze <= req.agcfreeze;
  endtask: drive_agcfreeze

  task drive_testmode(radio_ctrl_seq_item req);
    vif.tmode <= req.tmode;
  endtask: drive_testmode

  task drive_txrxsw(radio_ctrl_seq_item req);
    vif.trsw0 <= req.trsw0;
    vif.trsw1 <= req.trsw1;
  endtask: drive_txrxsw

  task drive_extpactrl(radio_ctrl_seq_item req);
    vif.extpaon_ch0_5G9 <= req.extpaon_ch0_5G9;
    vif.extpaon_ch0_2G4 <= req.extpaon_ch0_2G4;
    vif.extpaon_ch1_5G9 <= req.extpaon_ch1_5G9;
    vif.extpaon_ch1_2G4 <= req.extpaon_ch1_2G4;
  endtask: drive_extpactrl

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase

endclass : radio_ctrl_driver

`endif
