//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RADIO_CTRL_IF_SV
`define RADIO_CTRL_IF_SV

interface radio_ctrl_if;

  // Check flags
  bit   has_checks = 1;
  bit   has_coverage = 1;

  // signal declaration
  logic clk;
  logic rst_n;

  // SPI signals
  logic                 spi_miso;  // SPI Master IN slave OUT
  logic                 spi_ss_n;  // SPI slave select
  logic                 spi_clk;   // SPI clock
  logic                 spi_mosi;  // SPI Master OUT slave IN

  // GPIO signals
  logic [`GPIO_WIDTH-1:0] gpio;     // rf_gpio gain control value
  logic [`AGCC_WIDTH-1:0] AGCCount; // AGC sample count @80MHz

  // Reset
  logic                 resetn;

 // RF AGC Disable command
  logic                 agcfreeze;

  // Test mode
  logic                 tmode;

 // Tx/Rx switch
  logic                 trsw0;  // Antenna set 0
  logic                 trsw1;  // Antenna set 0

  // External PA control
  logic                 extpaon_ch0_5G9; // External power amplifier ON for antenna set 0 @ 6GHz
  logic                 extpaon_ch0_2G4; // External power amplifier ON for antenna set 0 @ 2.4GHz
  logic                 extpaon_ch1_5G9; // External power amplifier ON for antenna set 1 @ 6GHz
  logic                 extpaon_ch1_2G4; // External power amplifier ON for antenna set 1 @ 2.4GHz

  /***************************/
  /* ASSERTIONS              */
  /***************************/

  /***************************/
  /* COVERAGE                */
  /***************************/

endinterface : radio_ctrl_if

`endif
