//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RADIO_CTRL_MONITOR_SV
`define RADIO_CTRL_MONITOR_SV


class radio_ctrl_monitor extends uvm_monitor;

  virtual radio_ctrl_if vif;
  radio_ctrl_config     cfg;
  uvm_analysis_port #(radio_ctrl_seq_item) ap;

  bit rf_gpio6_1t;
  bit rf_new_gain_valid;
  bit [`GPIO_WIDTH-1:0] karst_gain;

  `uvm_component_utils(radio_ctrl_monitor)

  function new(string name = "radio_ctrl_monitor", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual radio_ctrl_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

    ap = new("ap", this);
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase

  function void initialize_vars();
    rf_new_gain_valid   = 0;
    rf_gpio6_1t         = 0;
    karst_gain          = `GPIO_WIDTH'd27;
  endfunction: initialize_vars

  task run_phase(uvm_phase phase);
    super.run_phase(phase);
    initialize_vars();
    fork
      collect_transaction();
      /* add some task calls here */
    join_none;
  endtask : run_phase


// -----------------------------------------------------------
// Wait on edge of clock for data reception
// -----------------------------------------------------------
  task spi_in_wait_clk_edge();
    if  ( ((cfg.spi_cpol == 0) && (cfg.spi_cpha == 1)) || ((cfg.spi_cpol == 1) && (cfg.spi_cpha == 0)) ) begin
      `uvm_info(get_type_name(), $sformatf("Waiting for clock faling edge (cpol: %1d cpha: %1d", cfg.spi_cpol, cfg.spi_cpha), UVM_HIGH)
      @(negedge vif.spi_clk);
    end else begin
      `uvm_info(get_type_name(), $sformatf("Waiting for clock rising edge (cpol: %1d cpha: %1d", cfg.spi_cpol, cfg.spi_cpha), UVM_HIGH)
      @(posedge vif.spi_clk);
    end
  endtask: spi_in_wait_clk_edge

// -----------------------------------------------------------
// Wait on edge of clock for data transmission
// -----------------------------------------------------------
  task spi_out_wait_clk_edge();
    if  ( ((cfg.spi_cpol == 0) && (cfg.spi_cpha == 1)) || ((cfg.spi_cpol == 1) && (cfg.spi_cpha == 0)) ) begin
      `uvm_info(get_type_name(), $sformatf("Waiting for clock rising edge (cpol: %1d cpha: %1d", cfg.spi_cpol, cfg.spi_cpha), UVM_HIGH)
      @(posedge vif.spi_clk);
    end else begin
      `uvm_info(get_type_name(), $sformatf("Waiting for clock faling edge (cpol: %1d cpha: %1d", cfg.spi_cpol, cfg.spi_cpha), UVM_HIGH)
      @(negedge vif.spi_clk);
    end
  endtask: spi_out_wait_clk_edge

// -----------------------------------------------------------
// Collect GPIO
// -----------------------------------------------------------
  task collect_gpio();
    forever begin
      radio_ctrl_seq_item item = radio_ctrl_seq_item::type_id::create("item");
      @(posedge vif.clk);
      rf_gpio6_1t = vif.gpio[6];
      do begin
        @(posedge vif.clk);
        if(vif.gpio[6]!=rf_gpio6_1t)begin
          karst_gain = { {(`GPIO_WIDTH-6){1'b0}} ,vif.gpio[5:0]};
          rf_new_gain_valid = 1'b1;
        end else begin
          rf_new_gain_valid = 1'b0;
          cfg.karst_gain_valid = 1'b0;
        end
        rf_gpio6_1t = vif.gpio[6];
      end while (rf_new_gain_valid == 1'b0);

      item.item_kind = GPIO;
      item.gpio = karst_gain;
      item.AGCCount = vif.AGCCount;
      cfg.karst_gain = karst_gain;
      cfg.karst_gain_valid = 1'b1;
      cfg.AGCCount = vif.AGCCount;

      `uvm_info(get_type_name(), $sformatf("Transaction collected :\n%s", item.sprint()), UVM_HIGH)

      if (cfg.has_checks)
        perform_checks();

      ap.write(item);
    end // forever
  endtask: collect_gpio


// -----------------------------------------------------------
// Collect SPI
// -----------------------------------------------------------
  task collect_spi();
    forever begin
      radio_ctrl_seq_item item = radio_ctrl_seq_item::type_id::create("item");

      wait (vif.spi_ss_n == cfg.spi_ss_pol);
      item.spi_data_miso = 0;
      item.spi_data_mosi = 0;
      for (int i=0; i< `SPI_DATA_WIDTH; i++) begin
        spi_in_wait_clk_edge();
        item.spi_data_miso = vif.spi_miso;
        item.spi_data_mosi = vif.spi_mosi;
        item.spi_data_miso <<= 1;
        item.spi_data_mosi <<= 1;
      end

      item.item_kind = SPI;

      `uvm_info(get_type_name(), $sformatf("Transaction collected :\n%s", item.sprint()), UVM_HIGH)

      if (cfg.has_checks)
        perform_checks();

      ap.write(item);
    end // forever
  endtask: collect_spi

  task collect_transaction();
      fork
        collect_spi();
        collect_gpio();
      join
  endtask : collect_transaction


  function void perform_checks();
  endfunction : perform_checks

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase


endclass : radio_ctrl_monitor

`endif //RADIO_CTRL_MONITOR_SV
