//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RADIO_CTRL_SEQ_ITEM_SV
`define RADIO_CTRL_SEQ_ITEM_SV


class radio_ctrl_seq_item extends uvm_sequence_item;

  rand radio_ctrl_item_kind_e    item_kind;

  rand bit [`SPI_DATA_WIDTH-1:0] spi_data_miso;
  rand bit [`SPI_DATA_WIDTH-1:0] spi_data_mosi;
  rand bit [`GPIO_WIDTH-1:0]     gpio;
  rand bit [`AGCC_WIDTH-1:0]     AGCCount;
  rand bit                       resetn;
  rand bit                       agcfreeze;
  rand bit                       tmode;
  rand bit                       trsw0;
  rand bit                       trsw1;
  rand bit                       extpaon_ch0_5G9;
  rand bit                       extpaon_ch0_2G4;
  rand bit                       extpaon_ch1_5G9;
  rand bit                       extpaon_ch1_2G4;

  `uvm_object_utils_begin(radio_ctrl_seq_item)
    `uvm_field_enum(radio_ctrl_item_kind_e, item_kind, UVM_DEFAULT)
    `uvm_field_int(spi_data_mosi, UVM_DEFAULT)
    `uvm_field_int(spi_data_miso, UVM_DEFAULT)
    `uvm_field_int(gpio, UVM_DEFAULT)
    `uvm_field_int(AGCCount, UVM_DEFAULT)
    `uvm_field_int(resetn, UVM_DEFAULT)
    `uvm_field_int(tmode, UVM_DEFAULT)
    `uvm_field_int(trsw0, UVM_DEFAULT)
    `uvm_field_int(trsw1, UVM_DEFAULT)
    `uvm_field_int(extpaon_ch0_5G9, UVM_DEFAULT)
    `uvm_field_int(extpaon_ch0_2G4, UVM_DEFAULT)
    `uvm_field_int(extpaon_ch0_2G4, UVM_DEFAULT)
    `uvm_field_int(extpaon_ch1_2G4, UVM_DEFAULT)
  `uvm_object_utils_end


  function new (string name = "radio_ctrl_seq_item");
    super.new(name);
  endfunction : new

endclass : radio_ctrl_seq_item

`endif //RADIO_CTRL_SEQ_ITEM_SV
