//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RUI_GEN_SAMPLES_SEQ_SV
`define RUI_GEN_SAMPLES_SEQ_SV

class rui_gen_samples_seq extends rui_seq_base;

  `uvm_object_utils(rui_gen_samples_seq)

  // variables holding matlab values
  AGC_mu_data_t rxFEout20_re [];
  AGC_mu_data_t rxFEout20_im [];
  AGC_mu_data_t rxFEout20S_re [];
  AGC_mu_data_t rxFEout20S_im [];
  AGC_mu_data_t rxFEout40_re [];
  AGC_mu_data_t rxFEout40_im [];
  AGC_mu_data_t rxFEout80_re [];
  AGC_mu_data_t rxFEout80_im [];

  bit [`BFRSIGMADB_WIDTH-1:0] bfrSigmadB[];
  bit [`SIGMAE2_WIDTH-1:0]    sigmae2;
  bit [31:0]                  snr_dB;
  bit [7:0]                   noise_variance;
  rxparameters_s              rxparams;

  function new(string name = "rui_gen_samples_seq");
    super.new(name);
  endfunction : new


  virtual task body();
    begin
      `uvm_info(get_type_name(), "Starting...", UVM_HIGH)
      req = rui_seq_item::type_id::create("req");

      start_item(req);
      req.rxFEout20_re  = this.rxFEout20_re;
      req.rxFEout20_im  = this.rxFEout20_im;
      req.rxFEout20S_re = this.rxFEout20S_re;
      req.rxFEout20S_im = this.rxFEout20S_im;
      req.rxFEout40_re  = this.rxFEout40_re;
      req.rxFEout40_im  = this.rxFEout40_im;
      req.rxFEout80_re  = this.rxFEout80_re;
      req.rxFEout80_im  = this.rxFEout80_im;
      req.bfrSigmadB    = this.bfrSigmadB;
      req.sigmae2       = this.sigmae2;
      req.snr_dB        = this.snr_dB;
      req.noise_variance = this.noise_variance;
      req.rxparams     = this.rxparams;
      finish_item(req);
    end
  endtask : body

endclass : rui_gen_samples_seq


`endif // RUI_GEN_SAMPLES_SEQ_SV
