//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RUI_AGENT_SV
`define RUI_AGENT_SV

//-----------------------------------

class rui_agent extends uvm_agent;

  rui_config    cfg;
  rui_driver    driver;
  rui_monitor   monitor;
  rui_coverage  coverage;
  rui_sequencer sequencer;

  `uvm_component_utils_begin(rui_agent)
    `uvm_field_object(cfg, UVM_DEFAULT)
  `uvm_component_utils_end

  function new (string name = "rui_agent", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    // Get Configuration
    if (!uvm_config_db#(rui_config)::get(this, "", "cfg", cfg)) begin
       `uvm_fatal(get_type_name(), "Config not set for slave agent using default is_active")
    end

    // Create components
    monitor = rui_monitor::type_id::create("monitor",this);
    monitor.cfg = cfg;
    if (cfg.has_coverage) begin
      coverage = rui_coverage::type_id::create("coverage", this);
    end

    if (cfg.is_active == UVM_ACTIVE) begin
      sequencer = rui_sequencer::type_id::create("sequencer",this);
      driver = rui_driver::type_id::create("driver",this);
    end

  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    if (cfg.has_coverage) begin
      monitor.ap.connect(coverage.analysis_export);
    end

    if (cfg.is_active == UVM_ACTIVE) begin
      driver.cfg = cfg;
      // Connect the driver to the sequencer using TLM interface
      driver.seq_item_port.connect(sequencer.seq_item_export);
    end
  endfunction : connect_phase

endclass : rui_agent

`endif
