//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RUI_CONFIG_SV
`define RUI_CONFIG_SV

class rui_config extends uvm_object;

  uvm_active_passive_enum        is_active = UVM_ACTIVE;
  bit                            has_coverage = 1;
  bit                            has_checks   = 1;
  bit                            agcBypass    = 0; // set to 1 when AGC is bypassed from testcase
  bit                            sig_error_injection = 0;
  bit                            set_snr_from_file = 0;
  string                         fname;

  `uvm_object_utils_begin(rui_config)
    `uvm_field_enum(uvm_active_passive_enum, is_active, UVM_DEFAULT)
    `uvm_field_int(has_coverage, UVM_DEFAULT)
    `uvm_field_int(has_checks, UVM_DEFAULT)
    `uvm_field_int(agcBypass, UVM_DEFAULT)
    `uvm_field_int(sig_error_injection, UVM_DEFAULT)
  `uvm_object_utils_end


  function new (string name = "rui_config");
    super.new(name);
    // create TC name from global settings
    fname = {`STRINGIFY(`SYSPARAM_TXT_DIR),"/",`TESTCASE_NAME,`TESTCASE_EXT};
  endfunction

endclass : rui_config

`endif
