//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RUI_IF_SV
`define RUI_IF_SV

interface rui_if;

  // Check flags
  logic   has_checks = 1;
  logic   has_coverage = 1;

  // signal declaration
  logic                                clk;            // PHY clock
  logic                                rst_n;          // reset, active low

  logic                                agcBypass;      // when 1 AGC bypass is active and the TB forces the values
  logic                                ADC0On;         // set to 1 from TB when ADC0 IF is activated
  logic                                ADC1On;         // set to 1 from TB when ADC1 IF is activated
  logic                                AGCOFDMLock;

  // FE input signals - timing domain
  logic                                 RxDataValidIn20;
  logic signed  [`AGC_SAMPLE_WIDTH-1:0] RxDataIn20PRe0;
  logic signed  [`AGC_SAMPLE_WIDTH-1:0] RxDataIn20PIm0;
  logic signed  [`AGC_SAMPLE_WIDTH-1:0] RxDataIn20PRe1;
  logic signed  [`AGC_SAMPLE_WIDTH-1:0] RxDataIn20PIm1;
  logic signed  [`AGC_SAMPLE_WIDTH-1:0] RxDataIn20SRe;
  logic signed  [`AGC_SAMPLE_WIDTH-1:0] RxDataIn20SIm;

  logic                                 RxDataValidIn40;
  logic signed  [`AGC_SAMPLE_WIDTH-1:0] RxDataIn40PRe0;
  logic signed  [`AGC_SAMPLE_WIDTH-1:0] RxDataIn40PIm0;
  logic signed  [`AGC_SAMPLE_WIDTH-1:0] RxDataIn40PRe1;
  logic signed  [`AGC_SAMPLE_WIDTH-1:0] RxDataIn40PIm1;

  logic                                 RxDataValidIn80;
  logic signed  [`AGC_SAMPLE_WIDTH-1:0] RxDataIn80PRe0;
  logic signed  [`AGC_SAMPLE_WIDTH-1:0] RxDataIn80PIm0;
  logic signed  [`AGC_SAMPLE_WIDTH-1:0] RxDataIn80PRe1;
  logic signed  [`AGC_SAMPLE_WIDTH-1:0] RxDataIn80PIm1;

  logic [`SNR_WIDTH-1:0]                agc_snr;
  logic                                 agc_update;
  logic [`BFRSIGMADB_WIDTH-1:0]         bfrSigmadB;
  logic [7:0]                           noise_variance;
  logic                                 data_done; // indication that TD or FD processing done
  // Time Domain Rx frame parameters
  logic                                 frm_param1_update;
  logic                                 frm_param2_update;
  logic                                 frm_param3_update;
  logic                                 frm_param4_update;
  logic                                 frm_param5_update;
  logic                                 frm_param6_update;
  logic [1:0]                           frm_param_cbw;
  logic [1:0]                           frm_param_gi_type;
  logic [1:0]                           frm_param_he_ltf_type;
  logic [1:0]                           frm_param_ness;
  logic [7:0]                           frm_param_he_sigb;
  logic [2:0]                           frm_param_nsts;
  logic [14:0]                          frm_param_nsymb;
  logic [2:0]                           frm_param_num_he_ltf;
  logic                                 frm_param_vht_ndp;
  logic [2:0]                           frm_param_tpe;
  logic [3:0]                           frm_format_mod;
  logic                                 frm_param_doppler;
  logic                                 frm_param_midamble;
  logic [8:0]                           frm_param_nma;
  logic                                 frm_param_dcm;
  logic [2:0]                           frm_param_hesigb_mcs;
  logic                                 frm_param_hesigb_dcm;

  // Frequency Domain Rx frame parameters
  logic [1:0]                           frm_param_nsd;
  logic [2:0]                           frm_param_nbpsc0;
  logic [2:0]                           frm_param_nbpsc1;
  logic [2:0]                           frm_param_nss;
  logic                                 frm_param_stbc;
  logic                                 frm_param_fec;
  logic                                 frm_param_smoothing;
  logic                                 frm_param_htndp;
  logic                                 frm_param_lsig6m;

  logic                                 frm_param5_rlsig;
  logic                                 frm_param4_hemu;

  logic [2:0]                           frm_param_nbpsc_hesigb;
  logic [2:0]                           frm_param_rutype;
  logic [5:0]                           frm_param_ruindex;

  logic [11:0]                          RatioNoiseSignal;
  logic [5:0]                           RatioShift;
  logic [21:0]                          FDCpeSlope;

  /***************************/
  /* ASSERTIONS              */
  /***************************/

  /***************************/
  /* COVERAGE                */
  /***************************/

endinterface : rui_if

`endif
