//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module itemuires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RUI_MONITOR_SV
`define RUI_MONITOR_SV


class rui_monitor extends uvm_monitor;

  virtual rui_if                    vif;
  rui_config                        cfg;
  uvm_analysis_port #(rui_seq_item) ap;

  `uvm_component_utils(rui_monitor)

  function new(string name = "rui_monitor", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual rui_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

    ap = new("ap", this);
  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    fork
      collect_transaction();
      /* add some task calls here */
    join_none;
  endtask : run_phase


  task collect_transaction();
    forever begin

      rui_seq_item item = rui_seq_item::type_id::create("item");

      wait (vif.agcBypass == 1);

      do begin
        @(negedge vif.clk); // wait for falling edge of `PHYCLK

        if (vif.RxDataValidIn20 == 1) begin
          item.rxFEout20_re = new [item.rxFEout20_re.size()+1] (item.rxFEout20_re); // add one more element
          item.rxFEout20_im = new [item.rxFEout20_im.size()+1] (item.rxFEout20_im); // add one more element
          item.rxFEout20_re[item.rxFEout20_re.size()-1][0] = vif.RxDataIn20PRe0;
          item.rxFEout20_im[item.rxFEout20_im.size()-1][0] = vif.RxDataIn20PIm0;

          if (`RW_NX_DERIV_NRX>=2) begin
            item.rxFEout20_re[item.rxFEout20_re.size()-1][1] = vif.RxDataIn20PRe1;
            item.rxFEout20_im[item.rxFEout20_im.size()-1][1] = vif.RxDataIn20PIm1;
          end

          if ((`BW_PARAM_CONFIG == 40) || (`BW_PARAM_CONFIG == 80))
          begin
            item.rxFEout20S_re = new [item.rxFEout20S_re.size()+1] (item.rxFEout20S_re); // add one more element
            item.rxFEout20S_im = new [item.rxFEout20S_im.size()+1] (item.rxFEout20S_im); // add one more element
            item.rxFEout20S_re[item.rxFEout20S_re.size()-1][0] = vif.RxDataIn20SRe;
            item.rxFEout20S_im[item.rxFEout20S_im.size()-1][0] = vif.RxDataIn20SIm;
          end

        end // vif.RxDataValidIn20 == 1

        if (vif.RxDataValidIn40 == 1) begin
          item.rxFEout40_re = new [item.rxFEout40_re.size()+1] (item.rxFEout40_re); // add one more element
          item.rxFEout40_im = new [item.rxFEout40_im.size()+1] (item.rxFEout40_im); // add one more element
          item.rxFEout40_re[item.rxFEout40_re.size()-1][0] = vif.RxDataIn40PRe0;
          item.rxFEout40_im[item.rxFEout40_im.size()-1][0] = vif.RxDataIn40PIm0;

          if (`RW_NX_DERIV_NRX>=2)
          begin
            item.rxFEout40_re[item.rxFEout40_re.size()-1][1] = vif.RxDataIn40PRe1;
            item.rxFEout40_im[item.rxFEout40_im.size()-1][1] = vif.RxDataIn40PIm1;
          end
        end// vif.RxDataValidIn40 == 1

        if (vif.RxDataValidIn80 == 1) begin
          item.rxFEout80_re = new [item.rxFEout80_re.size()+1] (item.rxFEout80_re); // add one more element
          item.rxFEout80_im = new [item.rxFEout80_im.size()+1] (item.rxFEout80_im); // add one more element
          item.rxFEout80_re[item.rxFEout80_re.size()-1][0] = vif.RxDataIn80PRe0;
          item.rxFEout80_im[item.rxFEout80_im.size()-1][0] = vif.RxDataIn80PIm0;

          if (`RW_NX_DERIV_NRX>=2)
          begin
            item.rxFEout80_re[item.rxFEout80_re.size()-1][1] = vif.RxDataIn80PRe1;
            item.rxFEout80_im[item.rxFEout80_im.size()-1][1] = vif.RxDataIn80PIm1;
          end
        end

        item.bfrSigmadB = new [item.bfrSigmadB.size()+1] (item.bfrSigmadB);
        item.bfrSigmadB[item.bfrSigmadB.size()-1] = vif.bfrSigmadB;
        // save RXPARAMETERS
        item.rxparams.cbw_f           = vif.frm_param_cbw;
        item.rxparams.gi_type_f       = vif.frm_param_gi_type;
        item.rxparams.he_ltf_type_f   = vif.frm_param_he_ltf_type;
        item.rxparams.ness_f          = vif.frm_param_ness;
        item.rxparams.he_sigb_f       = vif.frm_param_he_sigb;
        item.rxparams.nsts_f          = vif.frm_param_nsts;
        item.rxparams.nsymb_f         = vif.frm_param_nsymb;
        item.rxparams.num_he_ltf_f    = vif.frm_param_num_he_ltf;
        item.rxparams.vht_ndp_f       = vif.frm_param_vht_ndp;
        item.rxparams.doppler_f       = vif.frm_param_doppler;
        item.rxparams.midamble_f      = vif.frm_param_midamble;
        item.rxparams.nma_f           = vif.frm_param_nma;

        // frequency domain parameters
        item.rxparams.nsd_f           = vif.frm_param_nsd;
        item.rxparams.nbpsc0_f        = vif.frm_param_nbpsc0;
        item.rxparams.nbpsc1_f        = vif.frm_param_nbpsc1;
        item.rxparams.nss_f           = vif.frm_param_nss;
        item.rxparams.stbc_f          = vif.frm_param_stbc;
        item.rxparams.fec_f           = vif.frm_param_fec;
        item.rxparams.smoothing_f     = vif.frm_param_smoothing;
        item.rxparams.htndp_f         = vif.frm_param_htndp;
        item.rxparams.lsig6m_f        = vif.frm_param_lsig6m;

      end while (vif.agcBypass == 1);

      `uvm_info(get_type_name(), $sformatf("Transaction collected :\n%s", item.sprint()), UVM_HIGH)

      if (cfg.has_checks)
        perform_checks();

      ap.write(item);
    end// forever
  endtask : collect_transaction


  function void perform_checks();
  endfunction : perform_checks

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase


endclass : rui_monitor

`endif //RUI_MONITOR_SV
