//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RUI_SEQ_ITEM_SV
`define RUI_SEQ_ITEM_SV


class rui_seq_item extends uvm_sequence_item;

  AGC_mu_data_t rxFEout20_re [];
  AGC_mu_data_t rxFEout20_im [];
  AGC_mu_data_t rxFEout20S_re [];
  AGC_mu_data_t rxFEout20S_im [];
  AGC_mu_data_t rxFEout40_re [];
  AGC_mu_data_t rxFEout40_im [];
  AGC_mu_data_t rxFEout80_re [];
  AGC_mu_data_t rxFEout80_im [];

  bit [`BFRSIGMADB_WIDTH-1:0] bfrSigmadB[];
  bit [`SIGMAE2_WIDTH-1:0]    sigmae2;
  bit [31:0]                  snr_dB;
  bit [7:0]                   noise_variance;
  rxparameters_s              rxparams;

  `uvm_object_utils_begin(rui_seq_item)
    `uvm_field_array_int(bfrSigmadB, UVM_DEFAULT)
    `uvm_field_int(sigmae2, UVM_DEFAULT)
    `uvm_field_int(snr_dB, UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "rui_seq_item");
    super.new(name);
  endfunction : new

endclass : rui_seq_item

`endif //RUI_SEQ_ITEM_SV
