//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RADIO_CONFIG_SV
`define RADIO_CONFIG_SV

class radio_config extends uvm_object;
  /************************************/
  /* UVC configuration fields         */
  /************************************/
  bit         has_radio_ctrl_agent       = 1;
  bit         has_modem_stream_adc_agent = 1;
  bit         has_modem_stream_dac_agent = 1;
  bit         has_rui_agent              = 1;
  bit         has_coverage               = 1;
  /************************************/

  /*****************************************/
  /* list of agent configurations          */
  /*****************************************/
  radio_ctrl_config      m_radio_ctrl_cfg;
  modem_stream_config    m_modem_stream_adc_cfg;
  modem_stream_config    m_modem_stream_dac_cfg;
  rui_config             m_rui_cfg;
  /*****************************************/

  `uvm_object_utils_begin(radio_config)
    `uvm_field_int(has_radio_ctrl_agent, UVM_DEFAULT)
    `uvm_field_int(has_modem_stream_adc_agent, UVM_DEFAULT)
    `uvm_field_int(has_modem_stream_dac_agent, UVM_DEFAULT)
    `uvm_field_int(has_rui_agent, UVM_DEFAULT)
    `uvm_field_int(has_coverage, UVM_DEFAULT)
  `uvm_object_utils_end

  function new (string name = "radio_config");
    super.new(name);

    /******************************/
    /* create all configurations  */
    /******************************/
    m_radio_ctrl_cfg = radio_ctrl_config::type_id::create("m_radio_ctrl_cfg");
    m_modem_stream_adc_cfg = modem_stream_config::type_id::create("m_modem_stream_adc_cfg");
    m_modem_stream_dac_cfg = modem_stream_config::type_id::create("m_modem_stream_dac_cfg");
    m_rui_cfg = rui_config::type_id::create("m_rui_cfg");
  endfunction

endclass : radio_config

`endif
