//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RADIO_ENV_SV
`define RADIO_ENV_SV

//-----------------------------------

class radio_env extends uvm_env;
  `uvm_component_utils(radio_env)

  radio_config                   m_cfg;
  radio_virtual_sequencer        m_vsqr;
  radio_ctrl_agent               m_radio_ctrl_agent;
  modem_stream_agent#(`ADCWIDTH) m_modem_stream_adc_agent;
  modem_stream_agent#(`DACWIDTH) m_modem_stream_dac_agent;
  rui_agent                      m_rui_agent;

  function new (string name = "radio_env", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    // Get configuration
    if (!uvm_config_db #(radio_config)::get(this, "", "radio_config", m_cfg))
      `uvm_error(get_type_name(), "RADIO configuration not set in configuration DB!!!")

    // Create components
    m_vsqr = radio_virtual_sequencer::type_id::create("m_vsqr", this);

    if (m_cfg.has_modem_stream_adc_agent) begin
      uvm_config_db #(modem_stream_config)::set(this, "m_modem_stream_adc_agent", "cfg", m_cfg.m_modem_stream_adc_cfg);
      m_modem_stream_adc_agent = modem_stream_agent#(`ADCWIDTH)::type_id::create("m_modem_stream_adc_agent", this);
    end

    if (m_cfg.has_modem_stream_dac_agent) begin
      uvm_config_db #(modem_stream_config)::set(this, "m_modem_stream_dac_agent", "cfg", m_cfg.m_modem_stream_dac_cfg);
      m_modem_stream_dac_agent = modem_stream_agent#(`DACWIDTH)::type_id::create("m_modem_stream_dac_agent", this);
    end

    if (m_cfg.has_radio_ctrl_agent) begin
      uvm_config_db #(radio_ctrl_config)::set(this, "m_radio_ctrl_agent", "cfg", m_cfg.m_radio_ctrl_cfg);
      m_radio_ctrl_agent = radio_ctrl_agent::type_id::create("m_radio_ctrl_agent", this);
    end

    if (m_cfg.has_rui_agent) begin
      uvm_config_db #(rui_config)::set(this, "m_rui_agent", "cfg", m_cfg.m_rui_cfg);
      m_rui_agent = rui_agent::type_id::create("m_rui_agent", this);
    end

  endfunction : build_phase


  function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);

    /* connect environment components and handles */
    if (m_cfg.has_modem_stream_adc_agent) begin
      if (m_cfg.m_modem_stream_adc_cfg.is_active == UVM_ACTIVE)
        m_vsqr.m_modem_stream_adc_sqr = m_modem_stream_adc_agent.sequencer;
    end // has_modem_stream_agent

    if (m_cfg.has_radio_ctrl_agent) begin
      if (m_cfg.m_radio_ctrl_cfg.is_active == UVM_ACTIVE)
        m_vsqr.m_radio_ctrl_sqr = m_radio_ctrl_agent.sequencer;
    end // has_radio_ctrl_agent

    if (m_cfg.has_rui_agent) begin
      if (m_cfg.m_rui_cfg.is_active == UVM_ACTIVE)
        m_vsqr.m_rui_sqr = m_rui_agent.sequencer;
    end // has_radio_ctrl_agent

  endfunction : connect_phase

endclass : radio_env

`endif //RADIO_ENV_SV
