//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RST_IDLE_SEQ_SV
`define RST_IDLE_SEQ_SV

class rst_idle_seq extends rst_seq_base;

  rand int cycles;

  `uvm_object_utils(rst_idle_seq)


  function new(string name = "rst_idle_seq");
    super.new(name);
  endfunction : new


  virtual task body();
    begin
      `uvm_info(get_type_name(), "Starting...", UVM_HIGH)
      req = rst_seq_item::type_id::create("req");

      start_item(req);
      req.c_idle_off.constraint_mode(0);
      assert(req.randomize() with {
        req.idle == 1;
        req.idle_cycles_cnt == cycles;
      });
      finish_item(req);
    end
  endtask : body

endclass : rst_idle_seq


`endif //RST_IDLE_SEQ_SV

