//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RST_COVERAGE_SV
`define RST_COVERAGE_SV

class rst_coverage extends uvm_subscriber #(rst_seq_item);

  `uvm_component_utils(rst_coverage)

  rst_seq_item item;

  //-------------------------------------------------
  // Cover groups
  //-------------------------------------------------
  covergroup rst_active_cg(string name) ;
    option.per_instance = 1;
    option.auto_bin_max = 4;
    option.name = name;
    ACTIVE_LEVEL: coverpoint item.rst {
      bins LOW = {0};
      bins HIGH = {1};
    }

    HOLD_TIME: coverpoint item.hold_time;
    REMOVAL_TIME: coverpoint item.removal_time;

  endgroup : rst_active_cg

  function new(string name = "rst_coverage", uvm_component parent = null);
    super.new(name, parent);

    rst_active_cg = new(name);
  endfunction : new

  function void write(rst_seq_item t);
    item = t;
    rst_active_cg.sample();
  endfunction : write

endclass : rst_coverage

`endif //RST_COVERAGE_SV
