//////////////////////////////////////////////////////////////////////////////
//  Copyright (C) by RivieraWaves.
//  This module is a confidential and proprietary property of RivieraWaves
//  and a possession or use of this module requires written permission
//  from RivieraWaves.
//----------------------------------------------------------------------------
// $Author: $
// Company          : RivieraWaves
//----------------------------------------------------------------------------
// $Revision: $
// $Date: $
// ---------------------------------------------------------------------------
// Dependencies     : None
// Description      :
// Simulation Notes :
// Synthesis Notes  :
// Application Note :
// Simulator        :
// Parameters       :
// Terms & concepts :
// Bugs             :
// Open issues and future enhancements :
// References       :
// Revision History :
// ---------------------------------------------------------------------------
//
//
//////////////////////////////////////////////////////////////////////////////


`ifndef RST_DRIVER_SV
`define RST_DRIVER_SV


class rst_driver extends uvm_driver #(rst_seq_item);

  `uvm_component_utils(rst_driver)

  virtual rst_if vif;
  rst_config     cfg;


  function new (string name = "rst_driver", uvm_component parent = null);
    super.new(name, parent);
  endfunction : new

  virtual function void build_phase(uvm_phase phase);
    super.build_phase(phase);

    if(!uvm_config_db#(virtual rst_if)::get(this, "", "vif", vif))
      `uvm_fatal(get_type_name(),"virtual if not configured");

  endfunction : build_phase

  virtual function void connect_phase(uvm_phase phase);
    super.connect_phase(phase);
  endfunction : connect_phase


  task run_phase(uvm_phase phase);
    super.run_phase(phase);

    fork
      get_and_drive();
      /* add other tasks here */
    join_none;
  endtask : run_phase

  task initialize();
    vif.rst_sig <= !cfg.rst_polarity;
  endtask : initialize


  task get_and_drive();
    initialize();

    forever begin
      `uvm_info(get_type_name(), "Start of a bus cycle detected.", UVM_DEBUG)
      seq_item_port.get_next_item(req);
      `uvm_info(get_type_name(), "Got new item.", UVM_DEBUG)

      // wait set up amount of cycles
      if (req.idle) begin
        repeat (req.idle_cycles_cnt)
          @(posedge vif.clk_1mhz_sig);
      end
      else begin
        vif.rst_sig <= req.rst;     // drive reset
        #(1us * req.hold_time);     // wait amount of hold time [us]
        vif.rst_sig <= ~req.rst;    // release reset
        #(1us * req.removal_time);  // wait amount of removal time [us]
      end

      seq_item_port.item_done();
    end // forever
  endtask : get_and_drive

  function void report_phase(uvm_phase phase);
    super.report_phase(phase);
  endfunction : report_phase

endclass : rst_driver

`endif
